/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.jms;

import aurora.plugin.jms.IMessageHandler;
import aurora.plugin.jms.JmsMessageDispatch;
import aurora.service.IServiceFactory;
import aurora.service.ServiceInvoker;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;
import uncertain.util.resource.ILocatable;

public class DefaultMessageHandler
extends AbstractLocatableObject
implements IMessageHandler {
    private String name;
    private String procedure;
    private String javaClass;
    private IObjectRegistry registry;
    private IProcedureManager procedureManager;
    private IServiceFactory serviceFactory;

    public DefaultMessageHandler(IObjectRegistry registry) {
        this.registry = registry;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        ILogger logger = LoggingContext.getLogger((String)"aurora.plugin.jms", (IObjectRegistry)this.registry);
        logger.log(Level.INFO, "accepted a new message\uff01");
        System.err.println(new Date() + ": accepted a new message!");
        String key = "";
        String singletion = "";
        try {
            key = message.getStringProperty("key");
            singletion = message.getStringProperty("singleton");
        }
        catch (JMSException e1) {
            e1.printStackTrace();
        }
        if ("true".equals(singletion) && !JmsMessageDispatch.key.equals(key)) {
            logger.log(Level.INFO, ":\u4e0d\u662f\u672c\u670d\u52a1\u5668\u53d1\u51fa\u7684\u8bf7\u6c42\uff0c\u4e0d\u4f5c\u51fa\u54cd\u5e94\u3002\u53d1\u9001\u65b9\uff1a" + key);
            return;
        }
        if (this.procedureManager == null) {
            this.procedureManager = (IProcedureManager)this.registry.getInstanceOfType(IProcedureManager.class);
            if (this.procedureManager == null) {
                throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, IProcedureManager.class, (String)this.getClass().getName());
            }
            this.serviceFactory = (IServiceFactory)this.registry.getInstanceOfType(IServiceFactory.class);
            if (this.serviceFactory == null) {
                throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, IServiceFactory.class, (String)this.getClass().getName());
            }
        }
        if (this.procedure == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"procedure");
        }
        if (message == null) {
            logger.log(Level.WARNING, "message is null");
            return;
        }
        if (message instanceof TextMessage) {
            CompositeMap context = new CompositeMap();
            try {
                Enumeration en = message.getPropertyNames();
                while (en.hasMoreElements()) {
                    String messageName = (String)en.nextElement();
                    String parsed_content = message.getStringProperty(messageName);
                    context.putObject("/parameter/message/@" + messageName, (Object)parsed_content, true);
                }
            }
            catch (JMSException e1) {
                e1.printStackTrace();
            }
            try {
                logger.log(Level.CONFIG, "receive message text:{0}", new Object[]{((TextMessage)message).getText()});
                logger.log(Level.CONFIG, "load procedure:{0}", new Object[]{this.procedure});
                Procedure proc = null;
                try {
                    proc = this.procedureManager.loadProcedure(this.procedure);
                }
                catch (Exception ex) {
                    throw BuiltinExceptionFactory.createResourceLoadException((ILocatable)this, (String)this.procedure, (Throwable)ex);
                }
                String name = "JMS." + this.procedure;
                ServiceInvoker.invokeProcedureWithTransaction((String)name, (Procedure)proc, (IServiceFactory)this.serviceFactory, (CompositeMap)context);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Error when invoking procedure " + this.procedure, (Throwable)ex);
            }
            finally {
                context.clear();
            }
        } else {
            logger.log(Level.CONFIG, "This is not TextMessage.This is " + message.getClass().getCanonicalName());
        }
    }

    public String getProcedure() {
        return this.procedure;
    }

    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }

    public String getJavaClass() {
        return this.javaClass;
    }

    public void setJavaClass(String javaClass) {
        this.javaClass = javaClass;
    }
}

