/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.bm.BusinessModel;
import aurora.bm.DefaultAccessChecker;
import aurora.bm.IBusinessModelAccessChecker;
import aurora.bm.IBusinessModelAccessCheckerFactory;
import aurora.database.FetchDescriptor;
import aurora.database.service.BusinessModelService;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import java.util.HashSet;
import java.util.Iterator;
import uncertain.composite.CompositeMap;
import uncertain.core.IGlobalInstance;
import uncertain.ocm.IObjectRegistry;

public class DefaultAccessCheckerFactory
implements IBusinessModelAccessCheckerFactory,
IGlobalInstance {
    private DatabaseServiceFactory factory;
    DatabaseServiceFactory mServiceFactory;
    String mCheckServiceName;
    BusinessModel mCheckServiceModel;
    IObjectRegistry registry;
    private String optionField;
    private String valueField;
    private String valueFlag;
    private String[] optionFieldarryay;
    private String[] valueFieldarryay;

    public DefaultAccessCheckerFactory(DatabaseServiceFactory serviceFactory) {
        this.mServiceFactory = serviceFactory;
    }

    public String getValueField() {
        return this.valueField;
    }

    public void setValueField(String valueField) {
        this.valueField = valueField;
        this.valueFieldarryay = valueField.split(",");
    }

    public String getValueFlag() {
        return this.valueFlag;
    }

    public void setValueFlag(String valueFlag) {
        this.valueFlag = valueFlag;
    }

    public String getOptionField() {
        return this.optionField;
    }

    public void setOptionField(String optionField) {
        this.optionField = optionField;
        this.optionFieldarryay = optionField.split(",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBusinessModelAccessChecker getChecker(String model_name, CompositeMap session_context) throws Exception {
        HashSet<String> hs = new HashSet<String>();
        SqlServiceContext context = this.factory.createContextWithConnection();
        try {
            BusinessModelService service = this.mServiceFactory.getModelService(this.getCheckServiceName(), context.getObjectContext());
            session_context.put("bm_name", model_name);
            CompositeMap resultMap = service.queryAsMap(session_context, FetchDescriptor.fetchAll());
            if (resultMap != null) {
                Iterator it = resultMap.getChildIterator();
                if (it == null) {
                    DefaultAccessChecker defaultAccessChecker = new DefaultAccessChecker(hs);
                    return defaultAccessChecker;
                }
                while (it.hasNext()) {
                    CompositeMap record = (CompositeMap)it.next();
                    int l = this.optionFieldarryay.length;
                    for (int i = 0; i < l; ++i) {
                        if (!record.getString(this.optionFieldarryay[i]).equals(this.getValueFlag())) continue;
                        hs.add(this.valueFieldarryay[i]);
                    }
                }
            }
            DefaultAccessChecker defaultAccessChecker = new DefaultAccessChecker(hs);
            return defaultAccessChecker;
        }
        finally {
            if (context != null) {
                context.freeConnection();
            }
        }
    }

    public String getCheckServiceName() {
        return this.mCheckServiceName;
    }

    public void setCheckServiceName(String checkServiceName) {
        this.mCheckServiceName = checkServiceName;
    }

    public void onInitialize() throws Exception {
        this.factory = (DatabaseServiceFactory)this.registry.getInstanceOfType(DatabaseServiceFactory.class);
        this.mServiceFactory = (DatabaseServiceFactory)this.registry.getInstanceOfType(DatabaseServiceFactory.class);
    }

    public DefaultAccessCheckerFactory(IObjectRegistry registry) {
        this.registry = registry;
    }
}

