/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component;

import aurora.presentation.BuildSession;
import aurora.presentation.IViewBuilder;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import aurora.presentation.component.TemplateRenderer;
import aurora.presentation.component.ViewContextTagCreator;
import aurora.presentation.component.std.IDGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.ISingleton;
import uncertain.util.template.CompositeMapTagCreator;
import uncertain.util.template.ITagContent;
import uncertain.util.template.ITagCreatorRegistry;
import uncertain.util.template.TagCreatorRegistry;
import uncertain.util.template.TextTemplate;

public class HtmlPage
implements IViewBuilder,
ISingleton {
    public static final String EVENT_PREPARE_PAGE_CONTENT = "PreparePageContent";

    protected ITagCreatorRegistry createTagCreatorRegistry(BuildSession session, ViewContext view_context) {
        HtmlPageTagCreator creator = new HtmlPageTagCreator(session, view_context);
        TagCreatorRegistry reg = new TagCreatorRegistry();
        reg.setDefaultCreator(CompositeMapTagCreator.DEFAULT_INSTANCE);
        reg.registerTagCreator("page", creator);
        reg.setParent(session.getPresentationManager().getTagCreatorRegistry());
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        try {
            CompositeMap model = view_context.getModel();
            String pageid = IDGenerator.getInstance().generate();
            String title = session.getTitle();
            title = session.getLocalizedPrompt(title);
            title = TextParser.parse(title, model);
            view_context.getContextMap().put("title", title);
            view_context.getContextMap().put("pageid", pageid);
            view_context.getContextMap().put("contextPath", session.getContextPath());
            session.getSessionContext().put("pageid", pageid);
            session.fireBuildEvent(EVENT_PREPARE_PAGE_CONTENT, view_context, true);
        }
        catch (Exception ex) {
            throw new ViewCreationException("Error when fire 'PreparePageContent' event", ex);
        }
        ITagCreatorRegistry reg = this.createTagCreatorRegistry(session, view_context);
        TextTemplate template = TemplateRenderer.getViewTemplate(session, view_context, reg);
        try {
            template.createOutput(session.getWriter(), view_context.getModel());
        }
        finally {
            template.clear();
        }
    }

    @Override
    public String[] getBuildSteps(ViewContext context) {
        return null;
    }

    public static class HtmlPageTagCreator
    extends ViewContextTagCreator {
        BuildSession _session;

        public HtmlPageTagCreator(BuildSession _session, ViewContext context) {
            super(context);
            this._session = _session;
        }

        @Override
        public ITagContent createInstance(String namespace, String tag) {
            if ("content".equals(tag)) {
                ViewContext context = this.getViewContext();
                CompositeMap model = context.getModel();
                List view_list = context.getView().getChilds();
                return new PageContentTag(this._session, model, view_list);
            }
            return super.createInstance(namespace, tag);
        }
    }

    public static class PageContentTag
    implements ITagContent {
        BuildSession _session;
        CompositeMap model;
        Collection view_list;

        public PageContentTag(BuildSession _session, CompositeMap model, Collection view_list) {
            this._session = _session;
            this.model = model;
            this.view_list = view_list;
        }

        @Override
        public String getContent(CompositeMap context) {
            try {
                this._session.buildViews(this.model, this.view_list);
            }
            catch (Exception ex) {
                throw new RuntimeException("error when building page content", ex);
            }
            return null;
        }
    }
}

