/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeUtil;
import uncertain.util.XMLWritter;

public class XMLOutputter {
    public static final String CDATA_END = "]]>";
    public static final String CDATA_BEGIN = "<![CDATA[";
    public static final String DEFAULT_INDENT = "    ";
    boolean mUseNewLine;
    String mIndentString;
    boolean mGenerateCdata = true;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static XMLOutputter default_inst = new XMLOutputter("    ", true);

    public static XMLOutputter defaultInstance() {
        return default_inst;
    }

    public XMLOutputter() {
        this.mIndentString = DEFAULT_INDENT;
        this.mUseNewLine = true;
    }

    public XMLOutputter(String _indent, boolean _new_line) {
        this.mIndentString = _indent;
        this.mUseNewLine = _new_line;
    }

    String getIndentString(int level) {
        StringBuffer pre_indent = new StringBuffer();
        if (this.mIndentString != null) {
            for (int i = 0; i < level; ++i) {
                pre_indent.append(this.mIndentString);
            }
        }
        return pre_indent.toString();
    }

    static void getAttributeXML(Map map, StringBuffer attribs) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            attribs.append(" ").append(XMLWritter.getAttrib(key.toString(), value.toString()));
        }
    }

    void getChildXML(int level, List childs, StringBuffer buf, Map namespaces, Map prefix_mapping) {
        if (childs == null) {
            return;
        }
        for (CompositeMap map : childs) {
            buf.append(this.toXMLWithPrefixMapping(level, map, namespaces, prefix_mapping));
        }
    }

    static Map addRef(Map namespaces, String uri, CompositeMap map) {
        Integer count;
        if (uri == null) {
            return namespaces;
        }
        if (namespaces == null) {
            namespaces = new HashMap<String, Integer>();
        }
        Integer new_count = (count = (Integer)namespaces.get(map.getNamespaceURI())) != null ? new Integer(count + 1) : new Integer(1);
        namespaces.put(map.namespace_uri, new_count);
        return namespaces;
    }

    static void subRef(Map map, String uri) {
        if (uri == null) {
            return;
        }
        Integer count = (Integer)map.get(uri);
        if (count != null) {
            int value = count - 1;
            if (value <= 0) {
                map.remove(uri);
            } else {
                map.put(uri, new Integer(value));
            }
        }
    }

    public String toXML(CompositeMap map) {
        return this.toXML(map, false);
    }

    public String toXML(CompositeMap map, boolean namespace_in_root) {
        if (namespace_in_root) {
            Map prefix_mapping = CompositeUtil.getPrefixMapping(map);
            return this.toXMLWithPrefixMapping(0, map, null, prefix_mapping);
        }
        return this.toXMLWithPrefixMapping(0, map, null, null);
    }

    static StringBuffer appendNamespace(StringBuffer buf, Map prefix_mapping) {
        for (Map.Entry entry : prefix_mapping.entrySet()) {
            String namespace = (String)entry.getKey();
            String prefix = (String)entry.getValue();
            buf.append(" xmlns:").append(prefix).append("=\"").append(namespace).append("\"");
        }
        return buf;
    }

    String toXMLWithPrefixMapping(int level, CompositeMap map, Map namespaces, Map prefix_mapping) {
        StringBuffer attribs = new StringBuffer();
        StringBuffer childs = new StringBuffer();
        StringBuffer xml = new StringBuffer();
        String indent_str = this.getIndentString(level);
        String namespace_uri = map.getNamespaceURI();
        StringBuffer xmlns_declare = null;
        boolean need_new_line_local = this.mUseNewLine;
        if (prefix_mapping == null && namespace_uri != null) {
            boolean uri_exists = false;
            if (namespaces != null) {
                boolean bl = uri_exists = namespaces.get(namespace_uri) != null;
            }
            if (!uri_exists) {
                String xmlns = "xmlns";
                if (map.getPrefix() != null) {
                    xmlns = "xmlns:" + map.getPrefix();
                }
                attribs.append(" ").append(XMLWritter.getAttrib(xmlns, namespace_uri));
            }
            namespaces = XMLOutputter.addRef(namespaces, namespace_uri, map);
        }
        XMLOutputter.getAttributeXML(map, attribs);
        if (map.getChilds() == null) {
            if (map.getText() != null) {
                need_new_line_local = false;
                if (this.mGenerateCdata) {
                    childs.append(CDATA_BEGIN).append(map.getText()).append(CDATA_END);
                } else {
                    childs.append(XMLWritter.escape(map.getText()));
                }
            }
        } else {
            this.getChildXML(level + 1, map.getChilds(), childs, namespaces, prefix_mapping);
        }
        if (prefix_mapping == null) {
            XMLOutputter.subRef(namespaces, namespace_uri);
        }
        String elm = null;
        if (prefix_mapping == null) {
            elm = map.getRawName();
        } else {
            elm = map.getName();
            if (namespace_uri != null) {
                String prefix = (String)prefix_mapping.get(namespace_uri);
                elm = prefix + ":" + elm;
            }
            if (level == 0) {
                xmlns_declare = new StringBuffer();
                XMLOutputter.appendNamespace(xmlns_declare, prefix_mapping);
            }
        }
        xml.append(indent_str).append('<').append(elm);
        if (xmlns_declare != null) {
            xml.append(xmlns_declare);
        }
        xml.append(attribs);
        if (childs.length() > 0) {
            xml.append('>');
            if (need_new_line_local) {
                xml.append(LINE_SEPARATOR);
            }
            xml.append(childs);
            if (need_new_line_local) {
                xml.append(indent_str);
            }
            xml.append(XMLWritter.endTag(elm));
        } else {
            xml.append("/>");
        }
        if (this.mUseNewLine) {
            xml.append(LINE_SEPARATOR);
        }
        return xml.toString();
    }

    public static void saveToFile(File target_file, CompositeMap map) throws IOException {
        XMLOutputter.saveToFile(target_file, map, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(File target_file, CompositeMap map, String encoding) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(target_file);
            String xml_decl = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n";
            os.write(xml_decl.getBytes());
            String content = XMLOutputter.defaultInstance().toXML(map, true);
            os.write(content.getBytes(encoding));
            os.flush();
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    public boolean isUseNewLine() {
        return this.mUseNewLine;
    }

    public void setUseNewLine(boolean useNewLine) {
        this.mUseNewLine = useNewLine;
    }

    public String getIndentString() {
        return this.mIndentString;
    }

    public void setIndentString(String indentString) {
        this.mIndentString = indentString;
    }

    public boolean isGenerateCdata() {
        return this.mGenerateCdata;
    }

    public void setGenerateCdata(boolean generateCdata) {
        this.mGenerateCdata = generateCdata;
    }
}

