/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.action;

import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.JSONAdaptor;

public class DoDispatch {
    public static final String DEFAULT_JSON_CONTENT_TYPE = "application/json;charset=utf-8";
    Set arrayNameSet;
    String output;

    public void onDoDispatch(ServiceContext context) throws IOException, JSONException {
        CompositeMap cm = context.getObjectContext();
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance(cm);
        String httptype = svc.getRequest().getHeader("x-requested-with");
        if ("XMLHttpRequest".equals(httptype)) {
            JSONObject json = new JSONObject();
            json.put("success", false);
            CompositeMap error_map = svc.getServiceContext().getError();
            if (error_map != null) {
                JSONObject err = JSONAdaptor.toJSONObject(error_map);
                json.put("error", err);
            }
            this.prepareResponse(svc.getResponse());
            PrintWriter out = svc.getResponse().getWriter();
            json.write(out);
        } else {
            String uri;
            String url = context.getString("dispatch_url");
            if (url != null && (uri = svc.getRequest().getRequestURI()).indexOf(url) < 0) {
                svc.getResponse().sendRedirect(url);
            }
        }
    }

    void prepareArrayNameSet(ServiceContext context) {
        if (this.arrayNameSet == null) {
            this.arrayNameSet = new HashSet();
        }
        this.arrayNameSet.clear();
        Iterator it = context.getModel().getChildIterator();
        if (it != null) {
            while (it.hasNext()) {
                CompositeMap item = (CompositeMap)it.next();
                this.arrayNameSet.add(item.getName());
            }
        }
    }

    void prepareResponse(HttpServletResponse response) {
        response.setContentType(DEFAULT_JSON_CONTENT_TYPE);
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
    }
}

