/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.application.features.ILookupCodeProvider;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import uncertain.cache.ICache;
import uncertain.cache.INamedCacheFactory;
import uncertain.composite.CompositeMap;
import uncertain.core.IGlobalInstance;
import uncertain.exception.GeneralException;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;

public class CacheBasedLookupCodeProvider
extends AbstractLocatableObject
implements ILookupCodeProvider,
IGlobalInstance {
    private static final String DEFAULT_SORT_FIELD = "code_value_id";
    private INamedCacheFactory mCacheFactory;
    private String promptCacheName;
    private String listCacheName;
    private String lookupType = "cache";
    private String lookupSql;
    private String lookupModel;
    private String sortField;
    private ICache promptCache;
    private ICache listCache;

    public CacheBasedLookupCodeProvider(IObjectRegistry registry, INamedCacheFactory cacheFactory) {
        this.mCacheFactory = cacheFactory;
    }

    @Override
    public List getLookupList(String language, String lookup_code) throws Exception {
        List result = (List)this.listCache.getValue(this.getFullCacheKey(lookup_code, language));
        if (result != null) {
            this.sorList(result);
        }
        return result;
    }

    private void sorList(List result) {
        Collections.sort(result, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                CompositeMap r1 = (CompositeMap)arg0;
                CompositeMap r2 = (CompositeMap)arg1;
                String object1 = r1.getString(CacheBasedLookupCodeProvider.this.getSortField());
                String object2 = r2.getString(CacheBasedLookupCodeProvider.this.getSortField());
                return object1.compareTo(object2);
            }
        });
    }

    @Override
    public String getLookupPrompt(String language, String lookup_code, Object lookup_value) {
        Object prompt = this.promptCache.getValue(this.getFullCacheKey(lookup_code, lookup_value != null ? lookup_value.toString() : null, language));
        if (prompt != null) {
            return prompt.toString();
        }
        return null;
    }

    public void onInitialize() throws Exception {
        this.promptCache = this.mCacheFactory.getNamedCache(this.promptCacheName);
        if (this.promptCache == null) {
            throw new GeneralException("uncertain.cache.named_cache_not_found", new Object[]{this.promptCacheName}, this);
        }
        this.listCache = this.mCacheFactory.getNamedCache(this.listCacheName);
        if (this.listCache == null) {
            throw new GeneralException("uncertain.cache.named_cache_not_found", new Object[]{this.listCacheName}, this);
        }
    }

    @Override
    public String getLookupType() {
        return this.lookupType;
    }

    public void setLookupType(String lookupType) {
        this.lookupType = lookupType;
    }

    @Override
    public String getLookupSql() {
        return this.lookupSql;
    }

    public void setLookupSql(String lookupSql) {
        this.lookupSql = lookupSql;
    }

    @Override
    public String getLookupModel() {
        return this.lookupModel;
    }

    public void setLookupModel(String lookupModel) {
        this.lookupModel = lookupModel;
    }

    public String getSortField() {
        return this.sortField == null ? DEFAULT_SORT_FIELD : this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getFullCacheKey(String code, String language) {
        return code + "." + language;
    }

    public String getFullCacheKey(String code, String code_value, String language) {
        return code + "." + code_value + "." + language;
    }

    public String getListCacheName() {
        return this.listCacheName;
    }

    public void setListCacheName(String listCacheName) {
        this.listCacheName = listCacheName;
    }

    public String getPromptCacheName() {
        return this.promptCacheName;
    }

    public void setPromptCacheName(String promptCacheName) {
        this.promptCacheName = promptCacheName;
    }
}

