/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.msg;

import aurora.application.features.msg.IConsumer;
import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageDispatcher;
import aurora.application.features.msg.IMessageHandler;
import aurora.application.features.msg.IMessageStub;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.core.ILifeCycle;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.MessageFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;

public class AuroraClientInstance
extends AbstractLocatableObject
implements ILifeCycle,
IMessageStub {
    public static final String PLUGIN = "aurora.application.features.msg";
    private IMessageDispatcher[] mMessageDispatchers;
    private IMessageHandler[] mMessageHandlers;
    private IConsumer[] consumers;
    private String url;
    private IObjectRegistry registry;
    public ILogger logger;
    private Map<String, IMessageHandler> handlersMap = new HashMap<String, IMessageHandler>();
    private Map<String, IMessageDispatcher> dispatchersMap = new HashMap<String, IMessageDispatcher>();
    private Map<String, IConsumer> consumerMap;
    private boolean inited = false;

    public AuroraClientInstance(IObjectRegistry registry) {
        this.registry = registry;
    }

    @Override
    public boolean startup() {
        if (this.inited) {
            return true;
        }
        this.logger = LoggingContext.getLogger(PLUGIN, this.registry);
        MessageFactory.loadResource("resources.aurora_plugin_amq");
        if (this.url == null) {
            BuiltinExceptionFactory.createOneAttributeMissing(this, "url");
        }
        new Thread(){

            @Override
            public void run() {
                if (AuroraClientInstance.this.consumers != null) {
                    for (int i = 0; i < AuroraClientInstance.this.consumers.length; ++i) {
                        try {
                            AuroraClientInstance.this.consumers[i].init(AuroraClientInstance.this);
                            continue;
                        }
                        catch (Exception e) {
                            AuroraClientInstance.this.logger.log(Level.SEVERE, "init jms consumers failed!", e);
                        }
                    }
                }
            }
        }.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    AuroraClientInstance.this.onShutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.registry.registerInstance(IMessageStub.class, this);
        this.inited = true;
        return true;
    }

    public void onShutdown() throws Exception {
        if (this.consumers != null) {
            for (int i = 0; i < this.consumers.length; ++i) {
                this.consumers[i].onShutdown();
            }
        }
    }

    @Override
    public IMessageHandler getMessageHandler(String name) {
        return this.handlersMap.get(name);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public IMessageHandler[] getMessageHandlers() {
        return this.mMessageHandlers;
    }

    public void setMessageHandlers(IMessageHandler[] messageHandlers) {
        this.mMessageHandlers = messageHandlers;
        for (int i = 0; i < messageHandlers.length; ++i) {
            this.handlersMap.put(messageHandlers[i].getName(), messageHandlers[i]);
        }
    }

    public IMessageDispatcher[] getMessageDispatchers() {
        return this.mMessageDispatchers;
    }

    public void setMessageDispatchers(IMessageDispatcher[] messageDispatchers) {
        this.mMessageDispatchers = messageDispatchers;
        if (messageDispatchers != null) {
            for (int i = 0; i < messageDispatchers.length; ++i) {
                this.dispatchersMap.put(messageDispatchers[i].getTopic(), messageDispatchers[i]);
            }
        }
    }

    public IConsumer[] getConsumers() {
        return this.consumers;
    }

    public void setConsumers(IConsumer[] consumers) {
        this.consumers = consumers;
        if (consumers != null) {
            this.consumerMap = new HashMap<String, IConsumer>();
            if (consumers != null) {
                for (int i = 0; i < consumers.length; ++i) {
                    this.consumerMap.put(consumers[i].getTopic(), consumers[i]);
                }
            }
        }
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    @Override
    public IConsumer getConsumer(String topic) {
        return this.consumerMap.get(topic);
    }

    @Override
    public void shutdown() {
        try {
            this.onShutdown();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "shutdown aurora message instance failed!", e);
        }
    }

    @Override
    public IMessageDispatcher getDispatcher(String topic) {
        return this.dispatchersMap.get(topic);
    }

    @Override
    public void send(String topic, IMessage message, CompositeMap context) throws Exception {
        IMessageDispatcher sender = this.getDispatcher(topic);
        if (sender == null) {
            throw new IllegalArgumentException("Don't not define the MessageDispatcher for topic:" + topic);
        }
        sender.send(message, context);
    }
}

