/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.msg;

import aurora.application.features.msg.Event;
import aurora.application.features.msg.IConsumer;
import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageHandler;
import aurora.application.features.msg.IMessageStub;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;

public class Consumer
extends AbstractLocatableObject
implements IConsumer {
    private IObjectRegistry registry;
    private String topic;
    private String client;
    private Event[] events;
    private Map<String, String> eventMap = new HashMap<String, String>();
    private ILogger logger;
    private IMessageStub stub;

    public Consumer(IObjectRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void init(IMessageStub stub) throws Exception {
        if (this.topic == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "topic");
        }
        this.stub = stub;
        this.logger = LoggingContext.getLogger(this.getClass().getCanonicalName(), this.registry);
        this.logger.log(Level.CONFIG, "start Consumer for topic:" + this.topic + " successfull!");
    }

    @Override
    public void onMessage(IMessage msg) throws Exception {
        String messageText = msg.getText();
        String handlerName = this.eventMap.get(messageText);
        if (handlerName != null) {
            IMessageHandler handler = this.stub.getMessageHandler(handlerName);
            if (handler == null) {
                this.logger.log(Level.SEVERE, "Error when handle jsm message. Can't find the handler for name:'" + handlerName + "'.");
                throw new IllegalStateException("Can't find the handler for name:'" + handlerName + "'.");
            }
            handler.onMessage(msg);
        }
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setEvents(Event[] events) {
        this.events = events;
        if (events != null) {
            for (int i = 0; i < events.length; ++i) {
                Event event = events[i];
                if (event.getHandler() == null) continue;
                this.eventMap.put(event.getMessage(), event.getHandler());
            }
        }
    }

    public Event[] getEvents() {
        return this.events;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    @Override
    public void onShutdown() {
        this.eventMap.clear();
    }
}

