/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.msg;

import aurora.application.features.msg.IMessageStub;
import aurora.application.features.msg.Message;
import aurora.application.features.msg.Property;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class MessageCreator
extends AbstractEntry {
    public static final String MESSAGE_ATTR = "message";
    public static final String TOPIC_ATTR = "topic";
    private String message;
    private String topic;
    private Property[] properties;
    private IObjectRegistry mRegistry;

    public MessageCreator(IObjectRegistry registry) {
        this.mRegistry = registry;
    }

    @Override
    public void run(ProcedureRunner runner) throws Exception {
        IMessageStub messageStub;
        if (this.message == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, MESSAGE_ATTR);
        }
        if (this.topic == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, TOPIC_ATTR);
        }
        CompositeMap context = runner.getContext();
        CompositeMap pps = new CompositeMap("property");
        String parsedTopic = TextParser.parse(this.topic, context);
        String parsedMessage = TextParser.parse(this.message, context);
        if (this.properties != null) {
            for (Property p : this.properties) {
                p.putToMap(context, pps, true);
            }
        }
        if ((messageStub = (IMessageStub)this.mRegistry.getInstanceOfType(IMessageStub.class)) == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IMessageStub.class, this.getClass().getCanonicalName());
        }
        Message msg = new Message(parsedMessage, pps);
        messageStub.send(parsedTopic, msg, context);
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public void setProperties(Property[] properties) {
        this.properties = properties;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }
}

