/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.msg;

import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageDispatcher;
import aurora.application.features.msg.MessageDispatcher;
import aurora.events.E_TransactionCommit;
import aurora.events.E_TransactionRollBack;
import aurora.service.IService;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import uncertain.composite.CompositeMap;
import uncertain.event.IParticipantManager;
import uncertain.ocm.IObjectRegistry;

public class TrxMessageDispatcher
implements E_TransactionCommit,
E_TransactionRollBack,
IMessageDispatcher {
    protected IObjectRegistry mRegistry;
    protected String topic;
    protected IMessageDispatcher dispatcher;
    private ConcurrentHashMap<IService, Queue<IMessage>> serviceMap = new ConcurrentHashMap();

    public TrxMessageDispatcher(IObjectRegistry registry) {
        this.mRegistry = registry;
        this.dispatcher = this.createMessageDispatcher();
        this.startup();
    }

    protected IMessageDispatcher createMessageDispatcher() {
        return new MessageDispatcher(this.mRegistry);
    }

    @Override
    public int onTransactionRollBack(IService service) {
        Queue<IMessage> list = this.serviceMap.get(service);
        if (list == null || list.isEmpty()) {
            return 0;
        }
        this.serviceMap.remove(service);
        return 0;
    }

    @Override
    public int onTransactionCommit(IService service) {
        Queue<IMessage> list = this.serviceMap.get(service);
        if (list == null || list.isEmpty()) {
            return 0;
        }
        for (IMessage mo : list) {
            try {
                CompositeMap context = new CompositeMap();
                ServiceContext serviceContext = service.getServiceContext();
                if (serviceContext != null) {
                    context = serviceContext.getObjectContext();
                }
                this.dispatcher.setTopic(this.topic);
                this.dispatcher.send(mo, context);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.serviceMap.remove(service);
        return 0;
    }

    public boolean startup() {
        IParticipantManager pm = (IParticipantManager)this.mRegistry.getInstanceOfType(IParticipantManager.class);
        if (pm != null) {
            List commitListenerList = pm.getParticipantList("transaction-commit");
            commitListenerList.add(this);
            List rollbakcListenerList = pm.getParticipantList("transaction-rollback");
            rollbakcListenerList.add(this);
        }
        return true;
    }

    public void shutdown() {
        if (this.serviceMap != null) {
            this.serviceMap.clear();
        }
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Override
    public void send(IMessage message, CompositeMap context) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException("Context can't be null");
        }
        ServiceInstance service = ServiceInstance.getInstance(context);
        if (service == null) {
            throw new IllegalArgumentException("Can't get Service from context:" + context.toXML());
        }
        Queue<IMessage> queue = this.serviceMap.get(service);
        if (queue == null) {
            queue = new ConcurrentLinkedQueue<IMessage>();
            this.serviceMap.put(service, queue);
        }
        queue.add(message);
    }
}

