/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.bm.AbstractSqlCreator;
import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.IModelFactory;
import aurora.database.profile.IDatabaseFactory;
import aurora.database.service.BusinessModelServiceContext;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.InsertStatement;

public class InsertSqlCreator
extends AbstractSqlCreator {
    public InsertSqlCreator(IModelFactory model_fact, IDatabaseFactory db_fact) {
        super(model_fact, db_fact);
    }

    public InsertStatement createInsertStatement(BusinessModel model) {
        InsertStatement stmt = new InsertStatement(model.getBaseTable());
        Field[] fields = model.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.isForInsert()) continue;
            stmt.addInsertField(field.getPhysicalName(), field.getInsertExpression());
        }
        return stmt;
    }

    public void onCreateInsertStatement(BusinessModel model, BusinessModelServiceContext context) {
        InsertStatement statement = this.createInsertStatement(model);
        context.setStatement(statement);
    }

    public void onCreateInsertSql(ISqlStatement s, BusinessModelServiceContext context) {
        this.doCreateSql("insert", s, context);
    }
}

