/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.rsconsumer;

import aurora.database.IResultSetConsumer;
import aurora.database.rsconsumer.AttribMapping;
import aurora.database.rsconsumer.IRootMapAcceptable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.ocm.AbstractLocatableObject;

public class CompositeMapCreator
extends AbstractLocatableObject
implements IResultSetConsumer,
IRootMapAcceptable {
    protected CompositeMap rootMap;
    protected CompositeMap currentRecord;
    boolean hasRootMap = false;
    String prefix;
    String nameSpace;
    String localName;
    boolean attribAsCdata = false;
    boolean fetchOneRecord = false;
    String attribAsCdataList;
    AttribMapping[] attribMappings;
    Map attributeMappings = new HashMap();
    List attribAsCdatas;

    public CompositeMapCreator() {
    }

    public CompositeMapCreator(CompositeMap root) {
        this.setRoot(root);
    }

    @Override
    public void endRow() {
        if (!this.fetchOneRecord) {
            this.rootMap.addChild(this.currentRecord);
        }
    }

    @Override
    public void begin(String root_name) {
        if (!this.hasRootMap || this.rootMap == null) {
            this.rootMap = new CompositeMap(root_name);
        }
    }

    @Override
    public void end() {
    }

    @Override
    public void loadField(String name, Object value) {
        String newName = (String)this.attributeMappings.get(name);
        if (newName == null) {
            // empty if block
        }
        newName = name;
        this.currentRecord.put(newName, value);
        if (this.attribAsCdata && this.attribAsCdatas != null && this.attribAsCdatas.contains(name)) {
            String orginal = this.currentRecord.getText();
            this.currentRecord.setText(orginal != null ? orginal : "" + value);
        }
    }

    @Override
    public void newRow(String row_name) {
        if (this.fetchOneRecord) {
            this.currentRecord = this.rootMap;
            return;
        }
        this.currentRecord = new CompositeMap(row_name);
        if (this.nameSpace != null) {
            this.currentRecord.setNameSpace(this.prefix, this.nameSpace);
        }
        if (this.localName != null) {
            this.currentRecord.setName(this.localName);
        }
    }

    public CompositeMap getCompositeMap() {
        return this.rootMap;
    }

    @Override
    public Object getResult() {
        return this.getCompositeMap();
    }

    @Override
    public void setRecordCount(long count) {
        this.rootMap.put("totalCount", new Long(count));
    }

    @Override
    public void setRoot(CompositeMap root) {
        this.rootMap = root;
        this.hasRootMap = true;
    }

    @Override
    public CompositeMap getRoot() {
        return this.rootMap;
    }

    public AttribMapping[] getAttribMappings() {
        return this.attribMappings;
    }

    public void setAttribMappings(AttribMapping[] attribMappings) {
        this.attribMappings = attribMappings;
        if (attribMappings != null) {
            for (int i = 0; i < attribMappings.length; ++i) {
                AttribMapping map = attribMappings[i];
                this.attributeMappings.put(map.from, map.to);
            }
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public boolean getAttribAsCdata() {
        return this.attribAsCdata;
    }

    public void setAttribAsCdata(boolean attribAsCdata) {
        this.attribAsCdata = attribAsCdata;
    }

    public String getAttribAsCdataList() {
        return this.attribAsCdataList;
    }

    public void setAttribAsCdataList(String attribAsCdataList) {
        String[] atts;
        this.attribAsCdataList = attribAsCdataList;
        this.attribAsCdatas = new LinkedList();
        if (this.attribAsCdata && attribAsCdataList != null && (atts = attribAsCdataList.split(",")) != null) {
            for (int i = 0; i < atts.length; ++i) {
                this.attribAsCdatas.add(atts[i]);
            }
        }
    }

    public boolean getFetchOneRecord() {
        return this.fetchOneRecord;
    }

    public void setFetchOneRecord(boolean fetchOnRecord) {
        this.fetchOneRecord = fetchOnRecord;
    }
}

