/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.config.AccordionConfig;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class Accordion
extends Component {
    private static final String DEFAULT_CLASS = "layout-accordion";
    private static final String SELECTED = "selected";
    private static final String REF = "ref";
    private int bodyHeight;
    private int stripHeight = 25;

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return DEFAULT_CLASS;
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "accordion/Accordion.css");
        this.addJavaScript(session, context, "accordion/Accordion.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        this.addConfig("stripheight", new Integer(this.stripHeight));
        map.put("accordions", this.createAccordions(session, context));
        map.put("config", this.getConfigString());
    }

    private String createAccordions(BuildSession session, ViewContext context) throws IOException {
        List childs;
        CompositeMap view = context.getView();
        AccordionConfig ac = AccordionConfig.getInstance(view);
        Map map = context.getMap();
        CompositeMap accordions = ac.getAccordions();
        StringBuffer sb = new StringBuffer();
        JSONArray jsons = new JSONArray();
        if (null != accordions && null != (childs = accordions.getChilds())) {
            int numAccordions = childs.size();
            int i = 0;
            boolean isSelected = false;
            boolean singleMode = ac.isSingleMode();
            boolean showIcon = ac.isShowIcon();
            this.bodyHeight = ((Integer)map.get("height") - numAccordions * this.stripHeight) / (singleMode ? 1 : numAccordions);
            Iterator it = childs.iterator();
            this.addConfig("singlemode", new Boolean(singleMode));
            this.addConfig("showicon", new Boolean(showIcon));
            while (it.hasNext()) {
                CompositeMap accordion = (CompositeMap)it.next();
                if (!(isSelected && singleMode || !"true".equals(accordion.getString(SELECTED, "")))) {
                    isSelected = true;
                    sb.append(this.createAccordion(session, context, accordion, true, showIcon));
                } else {
                    sb.append(this.createAccordion(session, context, accordion, false, showIcon));
                }
                jsons.put(new JSONObject(accordion));
                ++i;
            }
        }
        this.addConfig("items", jsons);
        return sb.toString();
    }

    private String createAccordion(BuildSession session, ViewContext context, CompositeMap accordion, boolean isSelected, boolean showIcon) throws IOException {
        CompositeMap model = context.getModel();
        StringBuffer sb = new StringBuffer();
        sb.append("<DIV class='" + (isSelected ? "item-accordion selected" : "item-accordion") + "' style='height:" + (isSelected ? this.bodyHeight + this.stripHeight : this.stripHeight) + "px'><DIV class='strip'>");
        if (showIcon) {
            sb.append("<div class='item-accordion-btn'></div>");
        }
        sb.append(session.getLocalizedPrompt(accordion.getString("prompt")));
        sb.append("</DIV><DIV class='item-accordion-body' style='height:" + this.bodyHeight + "px;'>");
        String ref = accordion.getString(REF, "");
        if ("".equals(ref)) {
            List accordionChilds = accordion.getChilds();
            if (accordionChilds != null) {
                for (CompositeMap accordionChild : accordionChilds) {
                    try {
                        sb.append(session.buildViewAsString(model, accordionChild));
                    }
                    catch (Exception e) {
                        throw new IOException(e.getMessage());
                    }
                }
            } else if (!"".equals(accordion.getText())) {
                sb.append(accordion.getText());
            }
        }
        accordion.putString(REF, TextParser.parse(ref, model));
        sb.append("</DIV></DIV>");
        return sb.toString();
    }
}

