/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.json;

import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.ServiceOutputConfig;
import aurora.service.http.HttpServiceInstance;
import aurora.service.json.JSONServiceContext;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.JSONAdaptor;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.proc.ProcedureRunner;
import uncertain.util.LoggingUtil;

public class JSONServiceInterpreter {
    public static final String DEFAULT_JSON_CONTENT_TYPE = "application/json;charset=utf-8";
    public static final String HEAD_JSON_PARAMETER = "json-parameter";
    public static final String DEFAULT_JSON_PARAMETER = "_request_data";
    public static final String KEY_WRITE_BACK_INPUT = "write_back_input";
    static final JSONObject EMPTY_JSON_OBJECT = new JSONObject();
    public static String JSON_ACCESS_PARAMTER = "json_access";

    public int preParseParameter(JSONServiceContext ct) throws Exception {
        String content;
        if (!this.isJSONRequest(ct.getRequest(), ct)) {
            return 0;
        }
        JSONServiceContext service_context = ct;
        HttpServletRequest request = ct.getRequest();
        request.setCharacterEncoding("utf-8");
        String jparam = request.getHeader(HEAD_JSON_PARAMETER);
        if (jparam == null) {
            jparam = DEFAULT_JSON_PARAMETER;
        }
        if ((content = request.getParameter(jparam)) != null) {
            service_context.getParameter().remove(jparam);
            JSONObject jobj = new JSONObject(content);
            CompositeMap root = JSONAdaptor.toMap(jobj);
            if (root == null) {
                return 2;
            }
            CompositeMap param = root.getChild("parameter");
            if (param != null) {
                param.putAll(root);
                service_context.setParameter(param);
            }
            return 2;
        }
        return 0;
    }

    void prepareResponse(HttpServletResponse response) {
        response.setContentType(DEFAULT_JSON_CONTENT_TYPE);
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
    }

    public void writeResponse(ServiceContext service_context) throws IOException, JSONException {
        if (!this.isJSONRequest(service_context)) {
            return;
        }
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance(service_context.getObjectContext());
        String output = null;
        ServiceOutputConfig cfg = svc.getServiceOutputConfig();
        if (cfg != null) {
            output = cfg.getOutput();
        }
        JSONObject json = new JSONObject();
        json.put("success", service_context.isSuccess());
        boolean write_result = service_context.getBoolean("write_result", true);
        if (write_result) {
            CompositeMap result = null;
            if (output != null) {
                Object obj = service_context.getObjectContext().getObject(output);
                if (!(obj instanceof CompositeMap)) {
                    throw new IllegalArgumentException("Target for JSON output is not instance of CompositeMap: " + obj);
                }
                result = (CompositeMap)obj;
            } else {
                result = service_context.getModel();
            }
            if (result != null) {
                JSONObject o = JSONAdaptor.toJSONObject(result);
                json.put("result", o);
            }
        }
        this.prepareResponse(svc.getResponse());
        PrintWriter out = svc.getResponse().getWriter();
        json.write(out);
    }

    public void onCreateSuccessResponse(ServiceContext service_context) throws IOException, JSONException {
        if (this.isJSONRequest(service_context)) {
            this.writeResponse(service_context);
        }
    }

    public void onCreateFailResponse(ProcedureRunner runner) throws IOException, JSONException {
        ServiceContext context = ServiceContext.createServiceContext(runner.getContext());
        if (!this.isJSONRequest(context)) {
            return;
        }
        ILogger logger = LoggingContext.getLogger(context.getObjectContext(), "aurora.application");
        Throwable thr = runner.getException();
        if (thr != null) {
            LoggingUtil.logException(thr, logger);
        }
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance(context.getObjectContext());
        HttpServletResponse response = svc.getResponse();
        this.prepareResponse(response);
        PrintWriter out = response.getWriter();
        out.println("{ \"success\":false ");
        CompositeMap error = context.getError();
        if (error != null) {
            out.println(",\"error\":");
            out.println(JSONAdaptor.toJSONObject(error).toString());
        }
        out.println("} ");
        out.flush();
    }

    private boolean isJSONRequest(ServiceContext service_context) {
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance(service_context.getObjectContext());
        return this.isJSONRequest(svc.getRequest(), service_context);
    }

    private boolean isJSONRequest(HttpServletRequest request, ServiceContext context) {
        String httptype = request.getHeader("x-requested-with");
        if ("XMLHttpRequest".equals(httptype)) {
            return true;
        }
        if ("true".equals(request.getParameter(JSON_ACCESS_PARAMTER))) {
            return true;
        }
        return context.getRequestType() == null;
    }
}

