/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.SAXException;
import uncertain.cache.ICache;
import uncertain.cache.MapBasedCache;
import uncertain.composite.CaseInsensitiveMap;
import uncertain.composite.CharCaseProcessor;
import uncertain.composite.CompositeLoaderSilentyWrapper;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeMapParser;
import uncertain.composite.NameProcessor;
import uncertain.composite.decorate.ElementModifier;
import uncertain.util.resource.CachedSourceFileCleaner;
import uncertain.util.resource.ISourceFile;
import uncertain.util.resource.ISourceFileManager;
import uncertain.util.resource.SourceFileManager;

public class CompositeLoader {
    public static final String KEY_BASE_FILE = "_base_file";
    public static final String DEFAULT_EXT = "xml";
    String mBaseDir;
    String mDefaultExt;
    boolean mSupportXinclude = true;
    boolean mCaseInsensitive = false;
    NameProcessor mNameProcessor = null;
    ClassLoader mClassLoader = Thread.currentThread().getContextClassLoader();
    LinkedList mExtraPathList = null;
    ICache mCache;
    ISourceFileManager mSourceFileManager;
    boolean mCacheEnabled = false;
    boolean mSupportFileMerge = false;
    boolean mSaveNamespaceMapping = false;
    CompositeLoaderSilentyWrapper wrapper = new CompositeLoaderSilentyWrapper(this);

    public static CompositeLoader createInstanceForOCM(String extension) {
        CompositeLoader loader = new CompositeLoader();
        loader.ignoreAttributeCase();
        loader.setDefaultExt(extension == null ? DEFAULT_EXT : extension);
        return loader;
    }

    public static CompositeLoader createInstanceForOCM() {
        return CompositeLoader.createInstanceForOCM(DEFAULT_EXT);
    }

    public static CompositeLoader createInstanceWithExt(String default_file_ext) {
        CompositeLoader loader = new CompositeLoader();
        loader.setDefaultExt(default_file_ext);
        return loader;
    }

    public static CompositeLoader createInstanceWithBaseDir(String base_dir) {
        CompositeLoader loader = new CompositeLoader();
        loader.setBaseDir(base_dir);
        return loader;
    }

    CompositeMap parse(InputStream stream) throws IOException, SAXException {
        String base_file;
        CompositeMapParser p = new CompositeMapParser(this);
        CompositeMap m = p.parseStream(stream);
        if (this.mSupportFileMerge && (base_file = m.getString(KEY_BASE_FILE)) != null && m.getChilds() != null) {
            CompositeMap base = this.load(base_file);
            CompositeMap merged = ElementModifier.process(m.getChilds(), base);
            return merged;
        }
        return m;
    }

    protected CompositeMap getCachedMap(Object key) {
        return this.mCache == null ? null : (CompositeMap)this.mCache.getValue(key);
    }

    protected void saveCachedMap(Object key, CompositeMap map) {
        File source;
        if (this.mCache != null && map != null) {
            this.mCache.setValue(key, map);
        }
        if (this.mSourceFileManager != null && (source = map.getSourceFile()) != null) {
            ISourceFile sf = this.mSourceFileManager.addSourceFile(source);
            sf.addUpdateListener(new CachedSourceFileCleaner(this.mCache, key));
        }
    }

    public CompositeLoader() {
        this.mBaseDir = null;
        this.mDefaultExt = DEFAULT_EXT;
    }

    public CompositeLoader(String base_dir, String default_ext) {
        this.setBaseDir(base_dir);
        this.setDefaultExt(default_ext);
    }

    public void addExtraLoader(CompositeLoader loader) {
        if (this.mExtraPathList == null) {
            this.mExtraPathList = new LinkedList();
        }
        this.mExtraPathList.add(loader);
    }

    public void addDocumentPath(CompositeLoader loader) {
        this.addExtraLoader(loader);
    }

    public List getExtraLoader() {
        return this.mExtraPathList;
    }

    public String convertResourcePath(String path) {
        return path.replace('.', '/') + '.' + this.mDefaultExt;
    }

    public String convertResourcePath(String path, String file_ext) {
        return path.replace('.', '/') + '.' + file_ext;
    }

    public CompositeMap loadFromString(String str) throws IOException, SAXException {
        return this.parse(new ByteArrayInputStream(str.getBytes()));
    }

    public CompositeMap loadFromString(String str, String charsetName) throws IOException, SAXException {
        return this.parse(new ByteArrayInputStream(str.getBytes(charsetName)));
    }

    public CompositeMap loadFromStream(InputStream stream) throws IOException, SAXException {
        return this.parse(stream);
    }

    protected CompositeMap loadByURL_NC(String url) throws IOException, SAXException {
        InputStream stream = null;
        try {
            URL the_url = new URL(url);
            stream = the_url.openStream();
            CompositeMap compositeMap = this.parse(stream);
            return compositeMap;
        }
        catch (Throwable thr) {
            throw new IOException(thr.getMessage());
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public CompositeMap loadByURL(String url) throws IOException, SAXException {
        if (!this.getCacheEnabled()) {
            return this.loadByURL_NC(url);
        }
        CompositeMap m = this.getCachedMap(url);
        if (m == null) {
            m = this.loadByURL_NC(url);
            this.saveCachedMap(url, m);
        }
        return (CompositeMap)m.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeMap loadByFullFilePath_NC(String file_name) throws IOException, SAXException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file_name);
            CompositeMap map = this.parse(fis);
            map.setSourceFile(new File(file_name));
            CompositeMap compositeMap = map;
            return compositeMap;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public CompositeMap loadByFullFilePath(String file_name) throws IOException, SAXException {
        if (!this.getCacheEnabled()) {
            return this.loadByFullFilePath_NC(file_name);
        }
        CompositeMap m = this.getCachedMap(file_name);
        if (m == null) {
            m = this.loadByFullFilePath_NC(file_name);
            this.saveCachedMap(file_name, m);
        }
        return (CompositeMap)m.clone();
    }

    String getFullPath(String file_name) {
        String full_name = file_name;
        if (file_name == null) {
            return null;
        }
        if (this.mDefaultExt != null && file_name.indexOf(46) < 0) {
            full_name = full_name + '.' + this.mDefaultExt;
        }
        if (this.mBaseDir != null) {
            full_name = this.mBaseDir + full_name;
        }
        return full_name;
    }

    public File getFile(String file_name) {
        File file = new File(this.getFullPath(file_name));
        if (file.exists()) {
            return file;
        }
        if (this.mExtraPathList == null) {
            return null;
        }
        for (CompositeLoader ld : this.mExtraPathList) {
            file = ld.getFile(file_name);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    public CompositeMap loadByFile(String file_name) throws IOException, SAXException {
        String full_name = this.getFullPath(file_name);
        try {
            return this.loadByFullFilePath(full_name);
        }
        catch (IOException ex) {
            if (this.mExtraPathList == null) {
                throw ex;
            }
            for (CompositeLoader ld : this.mExtraPathList) {
                try {
                    CompositeMap m = ld.loadByFile(file_name);
                    return m;
                }
                catch (IOException nex) {
                }
            }
            throw ex;
        }
    }

    public CompositeMap load(String resource_name) throws IOException, SAXException {
        if (resource_name == null) {
            return null;
        }
        if (resource_name.indexOf(58) > 0) {
            return this.loadByURL(resource_name);
        }
        return this.loadByFile(resource_name);
    }

    public CompositeMap loadFromClassPath(String full_name) throws IOException, SAXException {
        return this.loadFromClassPath(full_name, this.mDefaultExt);
    }

    public CompositeMap loadFromClassPath(String full_name, String file_ext) throws IOException, SAXException {
        if (!this.mCacheEnabled || this.mCache == null) {
            return this.loadFromClassPath_NC(full_name, file_ext);
        }
        String name = full_name + '#' + file_ext;
        CompositeMap m = (CompositeMap)this.mCache.getValue(name);
        if (m == null) {
            m = this.loadFromClassPath_NC(full_name, file_ext);
            this.saveCachedMap(name, m);
        }
        return (CompositeMap)m.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeMap loadFromClassPath_NC(String full_name, String file_ext) throws IOException, SAXException {
        if (full_name == null) {
            throw new IllegalArgumentException("path to load CompositeMap is null");
        }
        InputStream stream = null;
        String path = this.convertResourcePath(full_name, file_ext);
        try {
            CompositeMap compositeMap;
            URL url = this.mClassLoader.getResource(path);
            String file = url == null ? null : url.getFile();
            boolean need_stream = false;
            if (file == null) {
                need_stream = true;
            } else {
                File f = new File(file);
                if (!f.exists()) {
                    need_stream = true;
                }
            }
            if (need_stream) {
                stream = this.mClassLoader.getResourceAsStream(path);
                if (stream == null) {
                    throw new IOException("Can't get resource from " + path);
                }
                compositeMap = this.parse(stream);
                return compositeMap;
            }
            compositeMap = this.loadByFullFilePath_NC(file);
            return compositeMap;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public String getBaseDir() {
        return this.mBaseDir;
    }

    public String getDefaultExt() {
        return this.mDefaultExt;
    }

    public void setBaseDir(String base_dir) {
        File f = new File(base_dir);
        if (!f.exists()) {
            throw new IllegalArgumentException("Directory not exists:" + base_dir);
        }
        int len = base_dir.length();
        this.mBaseDir = base_dir.charAt(len - 1) != '\\' && base_dir.charAt(len - 1) != '/' ? base_dir + File.separatorChar : base_dir;
    }

    public void setDefaultExt(String default_ext) {
        this.mDefaultExt = default_ext;
    }

    public boolean getSupportXInclude() {
        return this.mSupportXinclude;
    }

    public void setSupportXInclude(boolean support_xinclude) {
        this.mSupportXinclude = support_xinclude;
    }

    public CompositeMap createCompositeMap(String _prefix, String _uri, String _name) {
        if (this.mCaseInsensitive) {
            return new CaseInsensitiveMap(_prefix, _uri, _name);
        }
        return new CompositeMap(_prefix, _uri, _name);
    }

    public boolean getCaseInsensitive() {
        return this.mCaseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.mCaseInsensitive = caseInsensitive;
    }

    public boolean getCacheEnabled() {
        return this.mCacheEnabled;
    }

    public void setCacheEnabled(boolean cache_enabled) {
        this.mCacheEnabled = cache_enabled;
        if (this.mCacheEnabled && this.mCache == null) {
            this.mCache = new MapBasedCache();
        }
        if (this.mExtraPathList != null) {
            for (CompositeLoader l : this.mExtraPathList) {
                if (this.mCacheEnabled) {
                    l.setCache(this.mCache);
                }
                l.setCacheEnabled(cache_enabled);
            }
        }
    }

    public NameProcessor getNameProcessor() {
        return this.mNameProcessor;
    }

    public void setNameProcessor(NameProcessor name_processor) {
        this.mNameProcessor = name_processor;
    }

    public void ignoreAttributeCase() {
        CharCaseProcessor p = new CharCaseProcessor(1, 0);
        this.setNameProcessor(p);
    }

    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.mClassLoader = classLoader;
    }

    public boolean getSupportFileMerge() {
        return this.mSupportFileMerge;
    }

    public void setSupportFileMerge(boolean supportFileMerge) {
        this.mSupportFileMerge = supportFileMerge;
    }

    public boolean getSaveNamespaceMapping() {
        return this.mSaveNamespaceMapping;
    }

    public void setSaveNamespaceMapping(boolean saveNamespaceMapping) {
        this.mSaveNamespaceMapping = saveNamespaceMapping;
    }

    public ICache getCache() {
        return this.mCache;
    }

    public void setCache(ICache cache) {
        this.mCache = cache;
        if (this.mSourceFileManager == null) {
            this.mSourceFileManager = SourceFileManager.getInstance();
        }
    }

    public ISourceFileManager getSourceFileManager() {
        return this.mSourceFileManager;
    }

    public void setSourceFileManager(ISourceFileManager mSourceFileManager) {
        this.mSourceFileManager = mSourceFileManager;
    }

    public CompositeLoaderSilentyWrapper silently() {
        return this.wrapper;
    }
}

