/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.amq;

import aurora.application.features.msg.IConsumer;
import aurora.application.features.msg.IMessageDispatcher;
import aurora.application.features.msg.IMessageHandler;
import aurora.application.features.msg.IMessageStub;
import aurora.plugin.jms.JMSStub;
import aurora.plugin.jms.MessageDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import uncertain.core.ILifeCycle;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.util.resource.ILocatable;

public class AMQClientInstance
extends AbstractLocatableObject
implements ILifeCycle,
JMSStub {
    public static final String PLUGIN = "aurora.plugin.amq";
    private IMessageHandler[] mMessageHandlers;
    private IConsumer[] consumers;
    private String url;
    private IObjectRegistry registry;
    private Logger logger;
    private Map<String, IMessageHandler> handlersMap = new HashMap<String, IMessageHandler>();
    private IMessageDispatcher messageDispatcher;
    private ActiveMQConnectionFactory factory;
    private Map<String, IConsumer> consumerMap;
    private boolean started = false;

    public AMQClientInstance(IObjectRegistry registry) {
        this.registry = registry;
        this.messageDispatcher = new MessageDispatcher(registry);
    }

    public boolean startup() {
        if (this.started) {
            return true;
        }
        this.logger = Logger.getLogger(PLUGIN);
        if (this.url == null) {
            BuiltinExceptionFactory.createOneAttributeMissing((ILocatable)this, (String)"url");
        }
        this.factory = new ActiveMQConnectionFactory(this.url);
        this.registry.registerInstance(ConnectionFactory.class, (Object)this.factory);
        this.consumerMap = new HashMap<String, IConsumer>();
        if (this.consumers != null) {
            for (int i = 0; i < this.consumers.length; ++i) {
                this.consumerMap.put(this.consumers[i].getTopic(), this.consumers[i]);
            }
        }
        new Thread(){

            @Override
            public void run() {
                if (AMQClientInstance.this.consumers != null) {
                    for (int i = 0; i < AMQClientInstance.this.consumers.length; ++i) {
                        try {
                            AMQClientInstance.this.consumers[i].init((IMessageStub)AMQClientInstance.this);
                            continue;
                        }
                        catch (Exception e) {
                            AMQClientInstance.this.logger.log(Level.SEVERE, "init jms consumers failed!", e);
                        }
                    }
                }
            }
        }.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    AMQClientInstance.this.onShutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.registry.registerInstance(IMessageStub.class, (Object)this);
        this.started = true;
        return true;
    }

    public void onShutdown() throws Exception {
        if (this.consumers != null) {
            for (int i = 0; i < this.consumers.length; ++i) {
                this.consumers[i].onShutdown();
            }
        }
    }

    public IMessageHandler getMessageHandler(String name) {
        return this.handlersMap.get(name);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public IMessageHandler[] getMessageHandlers() {
        return this.mMessageHandlers;
    }

    public void setMessageHandlers(IMessageHandler[] messageHandlers) {
        this.mMessageHandlers = messageHandlers;
        for (int i = 0; i < messageHandlers.length; ++i) {
            this.handlersMap.put(messageHandlers[i].getName(), messageHandlers[i]);
        }
    }

    public IConsumer[] getConsumers() {
        return this.consumers;
    }

    public void setConsumers(IConsumer[] consumers) {
        this.consumers = consumers;
    }

    public ActiveMQConnectionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ActiveMQConnectionFactory factory) {
        this.factory = factory;
    }

    public IConsumer getConsumer(String topic) {
        return this.consumerMap.get(topic);
    }

    public void shutdown() {
        try {
            this.onShutdown();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "shutdown jms instance failed!", e);
        }
    }

    public IMessageDispatcher getDispatcher() {
        return this.messageDispatcher;
    }

    @Override
    public Connection createConnection() throws JMSException {
        if (this.factory == null) {
            throw new IllegalStateException("ConnectionFactory is not initialiaze!");
        }
        return this.factory.createConnection();
    }

    public boolean isStarted() {
        return this.started;
    }
}

