/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.jms;

import aurora.application.features.msg.Event;
import aurora.application.features.msg.IConsumer;
import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageHandler;
import aurora.application.features.msg.IMessageStub;
import aurora.plugin.jms.JMSMessage;
import aurora.plugin.jms.JMSStub;
import aurora.plugin.jms.JMSUtil;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.ConfigurationFileException;
import uncertain.exception.GeneralException;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.util.resource.ILocatable;

public class Consumer
extends AbstractLocatableObject
implements MessageListener,
ExceptionListener,
IConsumer {
    private IObjectRegistry registry;
    private String topic;
    private String client;
    private Event[] events;
    private Map<String, String> eventMap = new HashMap<String, String>();
    private ILogger logger;
    private Session session;
    private Connection connection;
    private MessageConsumer messageConsumer;
    private JMSStub jmsStub;

    public Consumer(IObjectRegistry registry) {
        this.registry = registry;
    }

    public void init(IMessageStub stub) throws Exception {
        if (!(stub instanceof JMSStub)) {
            throw new IllegalArgumentException("The IMessageStub is not IJMSMessageStub!");
        }
        this.jmsStub = (JMSStub)stub;
        if (this.topic == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"topic");
        }
        this.logger = LoggingContext.getLogger((String)"aurora.plugin.jms", (IObjectRegistry)this.registry);
        this.logger.log(Level.CONFIG, "init Consumer");
        this.connection = this.jmsStub.createConnection();
        this.connection.setExceptionListener((ExceptionListener)this);
        if (this.client == null) {
            this.client = this.getAutoClient(this.topic);
        }
        this.connection.setClientID(this.client);
        this.session = this.connection.createSession(false, 1);
        Topic jmsTopic = this.session.createTopic(this.topic);
        this.logger.log(Level.CONFIG, "create Topic:{0}", new Object[]{this.topic});
        this.messageConsumer = this.session.createDurableSubscriber(jmsTopic, this.topic);
        this.messageConsumer.setMessageListener((MessageListener)this);
        this.connection.start();
        this.logger.log(Level.CONFIG, "start Consumer successfull!");
    }

    public void onShutdown() {
        JMSUtil.freeMessageConsumer(this.messageConsumer);
        JMSUtil.freeJMSSession(this.session);
        JMSUtil.freeJMSConnection(this.connection);
    }

    public void onMessage(Message message) {
        if (!(message instanceof TextMessage)) {
            throw new GeneralException("aurora.msg.message_type_error", new Object[]{TextMessage.class.getName(), message.getClass().getCanonicalName()}, (ILocatable)this);
        }
        TextMessage textMessage = (TextMessage)message;
        String messageText = null;
        try {
            messageText = textMessage.getText();
        }
        catch (JMSException e) {
            throw new GeneralException("aurora.msg.jmsexception_error", new Object[]{e.getMessage()}, (Throwable)e);
        }
        String handlerName = this.eventMap.get(messageText);
        if (handlerName != null) {
            IMessageHandler handler = this.jmsStub.getMessageHandler(handlerName);
            if (handler == null) {
                ConfigurationFileException ex = new ConfigurationFileException("aurora.msg.handler_not_found_error", new Object[]{handlerName}, (ILocatable)this);
                this.logger.log(Level.SEVERE, "Error when handle jsm message", (Throwable)ex);
                throw ex;
            }
            handler.onMessage((IMessage)new JMSMessage(textMessage));
        }
    }

    public void onMessage(IMessage msg) throws Exception {
        throw new IllegalArgumentException("This method will never be called is this class!");
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public void setEvents(Event[] events) {
        this.events = events;
        if (events != null) {
            for (int i = 0; i < events.length; ++i) {
                Event event = events[i];
                if (event.getHandler() == null) continue;
                this.eventMap.put(event.getMessage(), event.getHandler());
            }
        }
    }

    public Event[] getEvents() {
        return this.events;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getAutoClient(String topic) {
        return Calendar.getInstance().getTimeInMillis() + (topic != null ? topic : "");
    }

    public void onException(JMSException paramJMSException) {
        paramJMSException.printStackTrace();
        this.logger.log(Level.SEVERE, "JMSException:", (Throwable)paramJMSException);
    }
}

