/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sync;

import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import uncertain.ocm.IObjectRegistry;

public class SyncUtil {
    public static Connection getConnection(String dataSourceName, IObjectRegistry registry) throws SQLException {
        DatabaseServiceFactory databasefactory = (DatabaseServiceFactory)registry.getInstanceOfType(DatabaseServiceFactory.class);
        SqlServiceContext sqlServiceContext = databasefactory.createContextWithConnection();
        Connection conn = sqlServiceContext.getNamedConnection(dataSourceName);
        if (conn == null) {
            sqlServiceContext.initConnection(registry, dataSourceName);
            conn = sqlServiceContext.getNamedConnection(dataSourceName);
        }
        conn.setAutoCommit(false);
        return conn;
    }

    public static void freeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLastSyncDate(Connection conn, String jobName) throws SQLException {
        String getLastSyncDateSql = "hpm_sync_pkg.getLastUpdated(?,?)";
        CallableStatement cstm = null;
        String syncDate = null;
        try {
            cstm = conn.prepareCall("{call hpm_sync_pkg.getLastUpdated(?,?)}");
            cstm.setString(1, jobName);
            cstm.registerOutParameter(2, 12);
            cstm.execute();
            syncDate = cstm.getString(2);
        }
        finally {
            if (cstm != null) {
                cstm.close();
            }
        }
        return syncDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlockSync(Connection conn, String jobName) throws SQLException {
        CallableStatement cstm = null;
        String unlockSql = "hpm_sync_pkg.unlock_hpm_sync(?)";
        try {
            cstm = conn.prepareCall("{call hpm_sync_pkg.unlock_hpm_sync(?)}");
            cstm.setString(1, jobName);
            cstm.execute();
        }
        finally {
            if (cstm != null) {
                cstm.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncSuccess(Connection conn, String jobName) throws SQLException {
        CallableStatement cstm = null;
        String unlockSql = "hpm_sync_pkg.sync_success(?)";
        try {
            cstm = conn.prepareCall("{call hpm_sync_pkg.sync_success(?)}");
            cstm.setString(1, jobName);
            cstm.execute();
        }
        finally {
            if (cstm != null) {
                cstm.close();
            }
        }
    }
}

