/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.application.config.ScreenConfig;
import aurora.events.E_DetectProcedure;
import aurora.presentation.cache.IResponseCacheProvider;
import aurora.service.IService;
import aurora.service.ServiceController;
import aurora.service.http.HttpServiceInstance;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.Level;
import javax.servlet.http.HttpServletResponse;
import uncertain.cache.ICache;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;

public class CachedScreenListener
implements E_DetectProcedure {
    public static final String CACHE_KEY = "__screen_cache_key";
    IResponseCacheProvider mCacheProvider;
    ICache mCache;

    public static String getFullKey(IResponseCacheProvider provider, HttpServiceInstance svc, String key) {
        File source = svc.getServiceConfigData().getSourceFile();
        if (source == null) {
            ILogger logger = LoggingContext.getLogger(svc.getContextMap(), "aurora.presentation");
            logger.warning("Can't get source file, thus file last update date can be append to cache key");
            return null;
        }
        if ((key = provider.getFullCacheKey(source, key)) != null) {
            key = TextParser.parse(key, svc.getContextMap());
        }
        return key;
    }

    public static void setCacheKey(CompositeMap context, String key) {
        context.put(CACHE_KEY, key);
    }

    public static String getCacheKey(CompositeMap context) {
        return context.getString(CACHE_KEY);
    }

    public CachedScreenListener(IResponseCacheProvider provider) {
        this.mCacheProvider = provider;
        this.mCache = provider.getCacheForResponse();
        if (this.mCache == null) {
            throw new IllegalStateException("Can't get named cache for screen");
        }
    }

    public static void writeCachedResponse(String contentType, HttpServiceInstance svc, String result) throws IOException {
        HttpServletResponse response = svc.getResponse();
        response.setContentType(contentType);
        PrintWriter out = response.getWriter();
        ((Writer)out).write(result);
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    public CacheResult getCachedContent(IService service) {
        CacheResult result = new CacheResult();
        HttpServiceInstance svc = (HttpServiceInstance)service;
        ScreenConfig screen = ScreenConfig.createScreenConfig(svc.getServiceConfigData());
        String key = screen.getCacheKey();
        result.key = key = CachedScreenListener.getFullKey(this.mCacheProvider, svc, key);
        if (key != null) {
            CachedScreenListener.setCacheKey(svc.getContextMap(), key);
            Object content = this.mCache.getValue(key);
            if (content != null) {
                result.content = content;
                result.hit = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int preDetectProcedure(IService service) throws Exception {
        HttpServiceInstance svc;
        ScreenConfig screen;
        boolean cacheEnabled;
        if (service instanceof HttpServiceInstance && (cacheEnabled = (screen = ScreenConfig.createScreenConfig((svc = (HttpServiceInstance)service).getServiceConfigData())).isCacheEnabled())) {
            ILogger logger = LoggingContext.getLogger(svc.getContextMap(), "aurora.presentation");
            CacheResult result = this.getCachedContent(svc);
            if (result.isHit()) {
                try {
                    CachedScreenListener.writeCachedResponse(screen.getContentType(), svc, result.getContent().toString());
                    logger.log(Level.FINE, "Write cached result to client using key {0}", new Object[]{result.getKey()});
                }
                finally {
                    ServiceController controller = svc.getController();
                    controller.setContinueFlag(false);
                    svc.getServiceContext().setSuccess(true);
                }
                return 2;
            }
            logger.log(Level.FINE, "Cache miss for key {0}, running normal screen render procedure", new Object[]{result.getKey()});
        }
        return 0;
    }

    @Override
    public int onDetectProcedure(IService service) throws Exception {
        return 0;
    }

    public static class CacheResult {
        String key;
        Object content;
        boolean hit = false;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Object getContent() {
            return this.content;
        }

        public void setContent(Object content) {
            this.content = content;
        }

        public boolean isHit() {
            return this.hit;
        }

        public void setHit(boolean hit) {
            this.hit = hit;
        }
    }
}

