/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.cache;

import aurora.application.features.cache.IEventHandler;
import aurora.application.features.cache.RecordReloadHandler;
import aurora.application.features.msg.IConsumer;
import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageStub;
import aurora.application.features.msg.INoticerConsumer;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.service.IServiceFactory;
import java.util.logging.Level;
import uncertain.cache.ICacheProvider;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;

public class EntityReloadHandler
extends RecordReloadHandler {
    private String operations;
    private String entity;

    @Override
    public void init(ICacheProvider provider, IObjectRegistry registry) {
        this.provider = provider;
        if (this.entity == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "entity");
        }
        IMessageStub stub = (IMessageStub)registry.getInstanceOfType(IMessageStub.class);
        if (stub == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IMessageStub.class, this.getClass().getName());
        }
        IConsumer consumer = stub.getConsumer(this.topic);
        if (!(consumer instanceof INoticerConsumer)) {
            throw BuiltinExceptionFactory.createInstanceTypeWrongException(this.getOriginSource(), INoticerConsumer.class, IConsumer.class);
        }
        this.dsFactory = (IDatabaseServiceFactory)registry.getInstanceOfType(IDatabaseServiceFactory.class);
        if (this.dsFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, DatabaseServiceFactory.class, this.getClass().getName());
        }
        if (this.operations == null) {
            StringBuffer sb = new StringBuffer("");
            for (int j = 0; j < IEventHandler.OPERATIONS.values().length; ++j) {
                if (j > 0) {
                    sb.append(",");
                }
                sb.append(IEventHandler.OPERATIONS.values()[j].name());
            }
            this.setOperations(sb.toString());
        }
        for (String op : this.getOperations().split(",")) {
            String message = this.getEntity().toLowerCase() + "/" + op;
            ((INoticerConsumer)consumer).addListener(message, this);
        }
        this.logger = LoggingContext.getLogger(this.getClass().getCanonicalName(), registry);
        this.procedureManager = (IProcedureManager)registry.getInstanceOfType(IProcedureManager.class);
        if (this.procedureManager == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IProcedureManager.class, this.getClass().getName());
        }
        this.serviceFactory = (IServiceFactory)registry.getInstanceOfType(IServiceFactory.class);
        if (this.serviceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IServiceFactory.class, this.getClass().getName());
        }
    }

    public String getOperations() {
        return this.operations;
    }

    public void setOperations(String operations) {
        this.operations = operations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(IMessage message) {
        this.provider.writeLock();
        try {
            if (message == null) {
                throw new IllegalArgumentException(" message can't be null!");
            }
            String text = message.getText();
            if (text == null) {
                throw new IllegalArgumentException(" Can't get text form message!");
            }
            String[] parts = text.split("/");
            String operation = parts[parts.length - 1];
            if (IEventHandler.OPERATIONS.delete.name().equals(operation)) {
                this.delete(message);
            } else if (IEventHandler.OPERATIONS.update.name().equals(operation)) {
                this.update(message);
            } else if (IEventHandler.OPERATIONS.insert.name().equals(operation)) {
                this.insert(message);
            } else if (IEventHandler.OPERATIONS.reload.name().equals(operation)) {
                this.reload(message);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "handle message exception", e);
        }
        finally {
            this.provider.writeUnLock();
        }
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }
}

