/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.service;

import aurora.bm.AbstractSqlCreator;
import aurora.bm.BusinessModel;
import aurora.bm.DeleteSqlCreator;
import aurora.bm.IModelFactory;
import aurora.bm.InsertSqlCreator;
import aurora.bm.ModelFactory;
import aurora.bm.QuerySqlCreator;
import aurora.bm.UpdateSqlCreator;
import aurora.database.features.AutoQueryCounter;
import aurora.database.features.LookUpField;
import aurora.database.features.OrderByClauseCreator;
import aurora.database.features.WhereClauseCreator;
import aurora.database.profile.IDatabaseFactory;
import aurora.database.service.BusinessModelService;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import uncertain.composite.CompositeMap;
import uncertain.core.UncertainEngine;
import uncertain.event.Configuration;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureRunner;

public class DatabaseServiceFactory
extends AbstractLocatableObject
implements IDatabaseServiceFactory {
    UncertainEngine uncertainEngine;
    IModelFactory modelFactory;
    DataSource dataSource;
    IDatabaseFactory databaseFactory;
    IProcedureManager mProcedureManager;
    Map defaultParticipantsMap = new HashMap();
    Configuration globalConfig;

    public static ILogger getLogger(CompositeMap context) {
        ILogger logger = LoggingContext.getLogger(context, "aurora.database");
        return logger;
    }

    public DatabaseServiceFactory(UncertainEngine engine) {
        this.uncertainEngine = engine;
        this.init();
    }

    protected void addDefaultParticipants() {
        QuerySqlCreator query_creator = new QuerySqlCreator(this.getModelFactory(), this.getDatabaseFactory());
        this.setGlobalParticipant(QuerySqlCreator.class, query_creator);
        UpdateSqlCreator update_creator = new UpdateSqlCreator(this.getModelFactory(), this.getDatabaseFactory());
        this.setGlobalParticipant(UpdateSqlCreator.class, update_creator);
        InsertSqlCreator insert_creator = new InsertSqlCreator(this.getModelFactory(), this.getDatabaseFactory());
        this.setGlobalParticipant(InsertSqlCreator.class, insert_creator);
        WhereClauseCreator where_creator = new WhereClauseCreator(this.getDatabaseFactory());
        this.setGlobalParticipant(WhereClauseCreator.class, where_creator);
        AutoQueryCounter auto_query_counter = new AutoQueryCounter(this.getDatabaseFactory());
        this.setGlobalParticipant(AutoQueryCounter.class, auto_query_counter);
        DeleteSqlCreator delete_creator = new DeleteSqlCreator(this.getModelFactory(), this.getDatabaseFactory());
        this.setGlobalParticipant(DeleteSqlCreator.class, delete_creator);
        LookUpField lookupfiled = new LookUpField(this.databaseFactory, this.uncertainEngine.getObjectRegistry());
        this.setGlobalParticipant(LookUpField.class, lookupfiled);
        this.setGlobalParticipant(OrderByClauseCreator.class, new OrderByClauseCreator());
    }

    protected void init() {
        Object fact;
        ILogger logger = this.uncertainEngine.getLogger("aurora.database");
        this.mProcedureManager = this.uncertainEngine.getProcedureManager();
        this.globalConfig = this.uncertainEngine.createConfig();
        IObjectRegistry os = this.uncertainEngine.getObjectRegistry();
        this.modelFactory = (IModelFactory)os.getInstanceOfType(IModelFactory.class);
        if (this.modelFactory == null) {
            fact = new ModelFactory(this.uncertainEngine.getOcManager());
            this.modelFactory = fact;
            os.registerInstance(IModelFactory.class, this.modelFactory);
        }
        this.dataSource = (DataSource)os.getInstanceOfType(DataSource.class);
        if (this.dataSource == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, DataSource.class);
        }
        logger.info("Using datasource " + this.dataSource);
        fact = (IDatabaseFactory)os.getInstanceOfType(IDatabaseFactory.class);
        if (fact == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IDatabaseFactory.class);
        }
        this.setDatabaseFactory((IDatabaseFactory)fact);
    }

    public Object getGlobalParticipant(Class type) {
        return this.defaultParticipantsMap.get(type);
    }

    public void setGlobalParticipant(Class type, Object instance) {
        if (!this.defaultParticipantsMap.containsKey(type)) {
            this.defaultParticipantsMap.put(type, instance);
            this.globalConfig.addParticipant(instance);
        }
    }

    public void setGlobalParticipant(Object instance) {
        this.setGlobalParticipant(instance.getClass(), instance);
    }

    @Override
    public SqlServiceContext createContextWithConnection() throws SQLException {
        SqlServiceContext context = this.createContext();
        Connection conn = null;
        conn = this.dataSource.getConnection();
        context.setConnection(conn);
        return context;
    }

    public SqlServiceContext createContext() {
        CompositeMap map = new CompositeMap("sql-service");
        return this.createContext(map);
    }

    public SqlServiceContext createContext(CompositeMap map) {
        SqlServiceContext context = SqlServiceContext.createSqlServiceContext(map);
        return context;
    }

    public ProcedureRunner loadProcedure(String class_path, CompositeMap context) {
        ProcedureRunner runner = new ProcedureRunner();
        Procedure proc = this.mProcedureManager.loadProcedure(class_path);
        if (proc == null) {
            throw new IllegalArgumentException("Can't load procedure " + class_path);
        }
        runner.setProcedure(proc);
        runner.setContext(context);
        return runner;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public IModelFactory getModelFactory() {
        return this.modelFactory;
    }

    @Override
    public void setModelFactory(IModelFactory factory) {
        this.modelFactory = factory;
    }

    public void updateSqlCreator(IModelFactory factory) {
        AbstractSqlCreator instance = (AbstractSqlCreator)this.getGlobalParticipant(QuerySqlCreator.class);
        if (instance != null) {
            instance.setModelFactory(factory);
        }
        if ((instance = (AbstractSqlCreator)this.getGlobalParticipant(UpdateSqlCreator.class)) != null) {
            instance.setModelFactory(factory);
        }
        if ((instance = (AbstractSqlCreator)this.getGlobalParticipant(DeleteSqlCreator.class)) != null) {
            instance.setModelFactory(factory);
        }
        if ((instance = (AbstractSqlCreator)this.getGlobalParticipant(InsertSqlCreator.class)) != null) {
            instance.setModelFactory(factory);
        }
    }

    @Override
    public BusinessModelService getModelService(String name) throws IOException {
        CompositeMap map = new CompositeMap("model-service-context");
        BusinessModelService bms = this.getModelService(name, map);
        return bms;
    }

    protected void prepareConfig(Configuration config) {
        for (Map.Entry entry : this.defaultParticipantsMap.entrySet()) {
            config.addParticipant(entry.getValue());
        }
    }

    @Override
    public BusinessModelService getModelService(BusinessModel model, CompositeMap context_map) throws IOException {
        Configuration config = this.uncertainEngine.createConfig();
        this.prepareConfig(config);
        config.loadConfig(model.getObjectContext());
        BusinessModelService service = null;
        try {
            service = new BusinessModelService(this, config, model, context_map);
            config.addParticipant(service);
            config.fireEvent("PrepareBusinessModel", new Object[]{model});
        }
        catch (Exception ex) {
            throw new RuntimeException("Error when creating business model service " + model.getName(), ex);
        }
        return service;
    }

    @Override
    public BusinessModelService getModelService(CompositeMap bm_config, CompositeMap context_map) throws IOException {
        BusinessModel model = this.modelFactory.getModel(bm_config);
        return this.getModelService(model, context_map);
    }

    @Override
    public BusinessModelService getModelService(String name, CompositeMap context_map) throws IOException {
        if (this.modelFactory == null) {
            throw new IllegalStateException("ModelFactory must be set first");
        }
        BusinessModel model = this.modelFactory.getModel(name);
        if (model == null) {
            throw new IllegalArgumentException("Can't load business model " + name);
        }
        return this.getModelService(model, context_map);
    }

    @Override
    public IDatabaseFactory getDatabaseFactory() {
        return this.databaseFactory;
    }

    @Override
    public void setDatabaseFactory(IDatabaseFactory databaseFactory) {
        this.databaseFactory = databaseFactory;
        this.addDefaultParticipants();
    }

    public IObjectRegistry getObjectRegistry() {
        return this.uncertainEngine == null ? null : this.uncertainEngine.getObjectRegistry();
    }
}

