/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.sql;

import aurora.database.sql.RawSqlExpression;
import aurora.database.sql.SelectField;
import java.util.LinkedList;
import java.util.List;

public class ComplexExpression
extends RawSqlExpression {
    List fields = new LinkedList();

    public ComplexExpression(String expressionText) {
        super(expressionText);
    }

    public void defineField(String name, SelectField field) {
        FieldDefine fd = new FieldDefine(name, field);
        this.fields.add(fd);
    }

    public void defineField(SelectField field) {
        this.defineField(Integer.toString(this.fields.size() + 1), field);
    }

    public void removeField(String field) {
        this.fields.remove(this.fields.indexOf(field));
    }

    public void removeField(SelectField field) {
        this.fields.remove(this.fields.indexOf(field));
    }

    public String getTranslatedExpression() {
        String text = this.getExpressionText();
        for (FieldDefine fd : this.fields) {
            text = text.replaceAll(fd.getRegexString(), fd.getField().getNameForOperate());
        }
        return text;
    }

    @Override
    public String toSql() {
        return this.getTranslatedExpression();
    }

    static class FieldDefine {
        String name;
        SelectField field;

        public FieldDefine(String name, SelectField field) {
            this.name = name;
            this.field = field;
        }

        public String getName() {
            return this.name;
        }

        public SelectField getField() {
            return this.field;
        }

        public boolean equals(Object another) {
            if (another instanceof String) {
                return this.name.equals(another);
            }
            if (another instanceof SelectField) {
                return this.field == another;
            }
            return super.equals(another);
        }

        public String getRegexString() {
            return "\\{" + this.name + "\\}";
        }
    }
}

