/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.sql;

import aurora.database.sql.AbstractStatementWithWhere;
import aurora.database.sql.ConditionList;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.Join;
import aurora.database.sql.OrderByField;
import aurora.database.sql.SelectField;
import aurora.database.sql.SelectSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SelectStatement
extends AbstractStatementWithWhere {
    List selectSourceList = this.getPartsNotNull(1);
    Map selectSourceMap;
    List selectFieldList = this.getPartsNotNull(0);
    List joinList = this.getPartsNotNull(3);

    public SelectStatement() {
        super("select");
        this.selectSourceMap = new HashMap();
    }

    public List getFromListForRead() {
        return Collections.unmodifiableList(this.selectSourceList);
    }

    public List getFieldsForRead() {
        return Collections.unmodifiableList(this.selectFieldList);
    }

    public void addSelectSource(SelectSource part) {
        part.setParent(this);
        this.selectSourceList.add(part);
        this.selectSourceMap.put(part.getTableName(), part);
    }

    public SelectSource addSelectSource(String tableName) {
        SelectSource part = new SelectSource(tableName);
        this.addSelectSource(part);
        return part;
    }

    public SelectSource addSelectSource(SelectStatement subQuery) {
        SelectSource part = new SelectSource(subQuery);
        this.addSelectSource(part);
        return part;
    }

    public SelectSource getSelectFrom(String tableName) {
        return (SelectSource)this.selectSourceMap.get(tableName);
    }

    void checkField(SelectField field) {
        if (field.isSubQuery()) {
            field.setParent(this);
        }
    }

    public void addSelectField(SelectField field) {
        this.selectFieldList.add(field);
        this.checkField(field);
    }

    public void addSelectField(int index, SelectField field) {
        this.selectFieldList.add(index, field);
        this.checkField(field);
    }

    public void addSelectFieldFirst(SelectField field) {
        this.selectFieldList.add(0, field);
        this.checkField(field);
    }

    public int getSelectFieldIndex(SelectField field) {
        return this.selectFieldList.indexOf(field);
    }

    public SelectField getField(String field_name) {
        for (Object fld : this.selectFieldList) {
            if (!(fld instanceof SelectField) || !((SelectField)fld).getFieldName().equals(field_name)) continue;
            return (SelectField)fld;
        }
        return null;
    }

    public void removeField(SelectField field) {
        this.selectFieldList.remove(field);
    }

    public boolean containsTable(String tableName) {
        return this.selectSourceMap.containsKey(tableName);
    }

    public void addJoin(Join join) {
        if (join.getLeftPart().getParent() != this) {
            this.addSelectSource(join.getLeftPart());
        }
        if (join.getRightPart().getParent() != this) {
            this.addSelectSource(join.getRightPart());
        }
        join.setParent(this);
        this.joinList.add(join);
    }

    public Join createJoin(String type, SelectSource s1, SelectSource s2) {
        if (!this.selectSourceList.contains(s1)) {
            this.addSelectSource(s1);
        }
        if (!this.selectSourceList.contains(s2)) {
            this.addSelectSource(s2);
        }
        Join join = new Join(type, s1, s2);
        this.addJoin(join);
        return join;
    }

    public Join createJoin(String type, String table1, String table2) {
        SelectSource s2;
        SelectSource s1 = this.getSelectFrom(table1);
        if (s1 == null) {
            s1 = this.addSelectSource(table1);
        }
        if ((s2 = this.getSelectFrom(table2)) == null) {
            s2 = this.addSelectSource(table2);
        }
        Join join = new Join(type, s1, s2);
        this.addJoin(join);
        return join;
    }

    public List getJoins() {
        return this.joinList;
    }

    public void addGroupByField(SelectField field) {
        this.getGroupByFields().add(field);
    }

    public void addGroupByField(int index, SelectField field) {
        this.getGroupByFields().add(index, field);
    }

    public List getGroupByFields() {
        return super.getPartsNotNull(4);
    }

    public void addOrderByField(ISqlStatement field, String order) {
        OrderByField f = new OrderByField(field, order);
        f.setParent(this);
        this.getOrderByFields().add(f);
    }

    public void addOrderByField(ISqlStatement field) {
        this.addOrderByField(field, null);
    }

    public void addOrderByField(OrderByField field) {
        this.getOrderByFields().add(field);
    }

    public List getOrderByFields() {
        return super.getPartsNotNull(6);
    }

    public void createDefaultAlias(String prefix) {
        int id = 1;
        for (SelectSource source : this.selectSourceList) {
            if (source.getAlias() != null) continue;
            String alias = prefix + id;
            source.setAlias(alias);
            ++id;
        }
    }

    public ConditionList getJoinConditions() {
        ConditionList list = new ConditionList();
        for (Join join : this.joinList) {
            list.addCondition(join.getJoinConditions());
        }
        return list;
    }
}

