/*
 * Decompiled with CFR 0.152.
 */
package aurora.i18n;

import aurora.i18n.CacheBasedLocalizedMessageProvider;
import aurora.i18n.ILocalizedMessageProvider;
import aurora.i18n.IMessageProvider;
import aurora.service.ServiceThreadLocal;
import java.text.MessageFormat;
import java.util.HashMap;
import uncertain.cache.ICache;
import uncertain.cache.INamedCacheFactory;
import uncertain.composite.TextParser;
import uncertain.core.IGlobalInstance;
import uncertain.exception.GeneralException;
import uncertain.ocm.AbstractLocatableObject;

public class CacheBasedMessageProvider
extends AbstractLocatableObject
implements IMessageProvider,
IGlobalInstance {
    private INamedCacheFactory mCacheFactory;
    private String langPath = "";
    private String defaultLang = "";
    private String cacheKey = "{0}.{1}";
    private String cacheName;
    private HashMap<String, ILocalizedMessageProvider> localMPMaps = new HashMap();
    private ICache cache;

    public CacheBasedMessageProvider(INamedCacheFactory cacheFactory) {
        this.mCacheFactory = cacheFactory;
    }

    public void onInitialize() throws Exception {
        this.cache = this.mCacheFactory.getNamedCache(this.cacheName);
        if (this.cache == null) {
            throw new GeneralException("uncertain.cache.named_cache_not_found", new Object[]{this.cacheName}, this);
        }
    }

    @Override
    public ILocalizedMessageProvider getLocalizedMessageProvider(String language_code) {
        ILocalizedMessageProvider messageProvider = this.localMPMaps.get(language_code);
        if (messageProvider == null) {
            messageProvider = new CacheBasedLocalizedMessageProvider(language_code, this);
        }
        return messageProvider;
    }

    @Override
    public String getMessage(String language_code, String message_code) {
        Object message = this.cache.getValue(this.getFullCacheKey(message_code, language_code));
        if (message == null) {
            return message_code;
        }
        return String.valueOf(message);
    }

    public void setMessage(String language_code, String message_code, String message) {
        this.cache.setValue(this.getFullCacheKey(message_code, language_code), message);
    }

    @Override
    public String getMessage(String language_code, String message_code, Object[] params) {
        return this.getMessage(language_code, message_code);
    }

    private String getFullCacheKey(String code, String language) {
        String patten = TextParser.parse(this.cacheKey, ServiceThreadLocal.getCurrentThreadContext());
        return MessageFormat.format(patten, code, language);
    }

    @Override
    public String getLangPath() {
        return this.langPath;
    }

    public void setLangPath(String langPath) {
        this.langPath = langPath;
    }

    @Override
    public String getDefaultLang() {
        return this.defaultLang;
    }

    public void setDefaultLang(String defaultLang) {
        this.defaultLang = defaultLang;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }
}

