/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.api.statistics.cvs;

import aurora.ide.api.statistics.cvs.CVSEntryLineTag;
import aurora.ide.api.statistics.cvs.FolderSyncInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class CVSFileReader {
    public static final String CVS_DIRNAME = "CVS";
    public static final String REPOSITORY = "Repository";
    public static final String ROOT = "Root";
    public static final String STATIC = "Entries.Static";
    public static final String TAG = "Tag";
    public static final String ENTRIES = "Entries";
    public static final String ENTRIES_LOG = "Entries.Log";
    public static final String NOTIFY = "Notify";
    public static final String BASE_DIRNAME = "Base";
    public static final String BASEREV = "Baserev";
    public static final String IGNORE_FILE = ".cvsignore";

    private static boolean folderExists(File cvsSubDir) {
        return cvsSubDir.isDirectory() && cvsSubDir.exists();
    }

    public static FolderSyncInfo readFolderSync(File folder) {
        File cvsSubDir = CVSFileReader.getCVSSubdirectory(folder);
        if (!CVSFileReader.folderExists(cvsSubDir)) {
            return null;
        }
        String root = CVSFileReader.readFirstLine(new File(cvsSubDir, ROOT));
        if (root == null) {
            return null;
        }
        String repository = CVSFileReader.readFirstLine(new File(cvsSubDir, REPOSITORY));
        if (repository == null) {
            return null;
        }
        String tag = CVSFileReader.readFirstLine(new File(cvsSubDir, TAG));
        CVSEntryLineTag cvsTag = tag != null ? new CVSEntryLineTag(tag) : null;
        String staticDir = CVSFileReader.readFirstLine(new File(cvsSubDir, STATIC));
        boolean isStatic = staticDir != null;
        return new FolderSyncInfo(repository, root, cvsTag, isStatic);
    }

    private static File getCVSSubdirectory(File folder) {
        return new File(folder, CVS_DIRNAME);
    }

    protected static boolean existsInFileSystem(File cvsSubDir) {
        return cvsSubDir.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readFirstLine(File file) {
        try {
            InputStream in = CVSFileReader.getInputStream(file);
            if (in == null) return null;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in), 512);
            try {
                String line = reader.readLine();
                if (line == null) {
                    String string = "";
                    return string;
                }
                String string = line;
                return string;
            }
            finally {
                reader.close();
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static InputStream getInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] readLines(File file) {
        String[] stringArray;
        InputStream in = CVSFileReader.getInputStream(file);
        if (in == null) return null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in), 512);
        ArrayList<String> fileContentStore = new ArrayList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                fileContentStore.add(line);
            }
            stringArray = fileContentStore.toArray(new String[fileContentStore.size()]);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        reader.close();
        return stringArray;
    }

    private static File getBaseDirectory(File file) {
        File cvsFolder = CVSFileReader.getCVSSubdirectory(file.getParentFile());
        File baseFolder = new File(cvsFolder, BASE_DIRNAME);
        return baseFolder;
    }

    public static boolean isEdited(File file) {
        File baseFolder = CVSFileReader.getBaseDirectory(file);
        File baseFile = new File(baseFolder, file.getName());
        return baseFile.exists();
    }
}

