/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation;

import aurora.presentation.BuildSession;
import aurora.presentation.DefaultResourceMapper;
import aurora.presentation.DefaultViewBuilder;
import aurora.presentation.IResourceUrlMapper;
import aurora.presentation.IViewBuilder;
import aurora.presentation.ViewComponent;
import aurora.presentation.ViewComponentPackage;
import aurora.presentation.component.ScreenIncludeTagCreator;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.logging.Level;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.core.DirectoryConfig;
import uncertain.core.IGlobalInstance;
import uncertain.core.UncertainEngine;
import uncertain.event.Configuration;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.MessageFactory;
import uncertain.logging.DummyLogger;
import uncertain.logging.DummyLoggerProvider;
import uncertain.logging.ILogger;
import uncertain.logging.ILoggerProvider;
import uncertain.logging.LoggingContext;
import uncertain.ocm.OCManager;
import uncertain.pkg.IPackageManager;
import uncertain.pkg.PackageManager;
import uncertain.pkg.PackagePath;
import uncertain.proc.ParticipantRegistry;
import uncertain.schema.SchemaManager;
import uncertain.util.template.ITagCreatorRegistry;
import uncertain.util.template.TagCreatorRegistry;
import uncertain.util.template.TagTemplateParser;
import uncertain.util.template.TextTemplate;

public class PresentationManager
implements IGlobalInstance {
    public static final String LOGGING_TOPIC = "aurora.presentation";
    OCManager mOcManager;
    ParticipantRegistry mRegistry;
    UncertainEngine mUncertainEngine;
    TagTemplateParser mParser = new TagTemplateParser();
    HashMap mComponentIdMap = new HashMap();
    PackageManager mPackageManager;
    ILogger mLogger;
    ILoggerProvider mLoggerProvider;
    IResourceUrlMapper mResourceUrlMapper = DefaultResourceMapper.getInstance();
    TagCreatorRegistry mTagCreatorRegistry = new TagCreatorRegistry();
    DefaultViewBuilder mDefaultViewBuilder = new DefaultViewBuilder();

    public PresentationManager() {
        this.mOcManager = OCManager.getInstance();
        this.mRegistry = ParticipantRegistry.defaultInstance();
        CompositeLoader loader = CompositeLoader.createInstanceForOCM();
        this.mPackageManager = new PackageManager(loader, this.mOcManager, new SchemaManager());
        ViewComponentPackage.loadBuiltInRegistry(this.mOcManager.getClassRegistry());
        this.mLogger = DummyLogger.getInstance();
        this.mLoggerProvider = DummyLoggerProvider.getInstance();
    }

    public PresentationManager(UncertainEngine engine) {
        this.mUncertainEngine = engine;
        this.mOcManager = engine.getOcManager();
        this.mRegistry = engine.getParticipantRegistry();
        this.mPackageManager = engine.getPackageManager();
        ViewComponentPackage.loadBuiltInRegistry(engine.getClassRegistry());
        this.mLoggerProvider = LoggingContext.getLoggerProvider(engine.getObjectRegistry());
        this.mLogger = this.mLoggerProvider.getLogger(LOGGING_TOPIC);
        this.mTagCreatorRegistry.registerTagCreator("screen", new ScreenIncludeTagCreator(engine.getObjectRegistry()));
        this.mLogger.info("Aurora Presentation Framework Startup... ");
    }

    public BuildSession createSession(Writer writer) {
        BuildSession session = new BuildSession(this);
        session.setWriter(writer);
        ILogger logger = this.mLoggerProvider.getLogger("aurora.presentation.buildsession");
        session.setLogger(logger);
        return session;
    }

    public Configuration createConfiguration() {
        if (this.mUncertainEngine == null) {
            return new Configuration(this.mRegistry, this.mOcManager);
        }
        return this.mUncertainEngine.createConfig();
    }

    protected ViewComponent getComponent(CompositeMap view) {
        return (ViewComponent)this.mComponentIdMap.get(view.getQName());
    }

    public IViewBuilder getViewBuilder(CompositeMap view_config) {
        ViewComponent component = this.getComponent(view_config);
        if (component == null) {
            return this.getDefaultViewBuilder();
        }
        Class type = component.getBuilder();
        if (type == null) {
            return null;
        }
        try {
            return (IViewBuilder)this.mOcManager.getObjectCreator().createInstance(type);
        }
        catch (Exception ex) {
            throw new RuntimeException("can't create instance of " + type.getName() + " when getting IViewBuilder from view config");
        }
    }

    public ViewComponentPackage getPackage(CompositeMap view) {
        ViewComponent component = this.getComponent(view);
        if (component == null) {
            return null;
        }
        return component.getOwner();
    }

    public ViewComponentPackage getPackage(String name) {
        return (ViewComponentPackage)this.mPackageManager.getPackage(name);
    }

    public IPackageManager getPackageManager() {
        return this.mPackageManager;
    }

    public ViewComponentPackage loadViewComponentPackage(String path) throws IOException {
        this.mLogger.log(Level.INFO, " =============== Loading package from " + path);
        ViewComponentPackage pkg = null;
        pkg = (ViewComponentPackage)this.mPackageManager.loadPackage(path, ViewComponentPackage.class);
        this.addPackage(pkg);
        this.mLogger.log(Level.INFO, "Loaded package " + pkg.getName());
        return pkg;
    }

    public void addPackage(ViewComponentPackage p) {
        if (p.getComponentMap() != null) {
            this.mComponentIdMap.putAll(p.getComponentMap());
        }
        if (this.mUncertainEngine != null && p.getClassRegistry() != null) {
            this.mUncertainEngine.getClassRegistry().addAll(p.getClassRegistry());
        }
        this.mLogger.log(Level.CONFIG, "Components:{0}", new Object[]{p.getComponentMap()});
    }

    public TextTemplate parseTemplate(File template_file, ITagCreatorRegistry reg) throws IOException {
        if (reg != null) {
            return this.mParser.buildTemplate(template_file, reg);
        }
        return this.mParser.buildTemplate(template_file);
    }

    public TagTemplateParser getTemplateParser() {
        return this.mParser;
    }

    public void addPackages(PackagePath[] pkg_path) throws IOException {
        DirectoryConfig dc = this.mUncertainEngine.getDirectoryConfig();
        this.mLogger.log(Level.CONFIG, "Loading " + pkg_path.length + " view component packages");
        for (int i = 0; i < pkg_path.length; ++i) {
            String path = pkg_path[i].getPath();
            if (path == null) {
                throw BuiltinExceptionFactory.createAttributeMissing(pkg_path[i], "path");
            }
            path = dc.translateRealPath(path);
            DirectoryConfig.checkIsPathValid(pkg_path[i], path);
            this.loadViewComponentPackage(path);
        }
    }

    public IResourceUrlMapper getResourceUrlMapper() {
        return this.mResourceUrlMapper;
    }

    public void setResourceUrlMapper(IResourceUrlMapper resourceUrlMapper) {
        this.mResourceUrlMapper = resourceUrlMapper;
    }

    public ITagCreatorRegistry getTagCreatorRegistry() {
        return this.mTagCreatorRegistry;
    }

    public ILoggerProvider getLoggerProvider() {
        return this.mLoggerProvider;
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public void setLogger(ILogger logger) {
        this.mLogger = logger;
    }

    public IViewBuilder getDefaultViewBuilder() {
        return this.mDefaultViewBuilder;
    }

    static {
        MessageFactory.loadResource("resources.aurora_presentation_exceptions");
    }
}

