/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.TextField;
import aurora.presentation.component.std.config.NumberFieldConfig;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;

public class NumberField
extends TextField {
    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        CompositeMap view = context.getView();
        NumberFieldConfig nfc = NumberFieldConfig.getInstance(view);
        if (!nfc.isAllowDecimals()) {
            this.addConfig("allowdecimals", new Boolean(false));
        }
        if (!nfc.isAllowNegative()) {
            this.addConfig("allownegative", new Boolean(false));
        }
        if (!nfc.isAllowFormat()) {
            this.addConfig("allowformat", new Boolean(false));
        }
        this.addConfig("decimalprecision", new Integer(nfc.getDecimalPrecision()));
        Map map = context.getMap();
        map.put(INPUT_TYPE, DEFAULT_INPUT_TYPE);
        map.put("config", this.getConfigString());
    }
}

