/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.lock;

import aurora.application.util.LanguageUtil;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.lock.IServiceSessionLock;
import aurora.service.lock.ServiceSessionLock;
import aurora.service.validation.ErrorMessage;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.ILifeCycle;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.ISingleton;
import uncertain.proc.ProcedureRunner;

public class SessionLockChecker
implements ISingleton,
ILifeCycle {
    IServiceSessionLock mSessionLock;
    IObjectRegistry mObjectRegistry;
    boolean featureEnabled = true;
    boolean defaultCheckAll = false;
    String sessionKey = "${/session/@session_id}";
    String errorMessage = "PROMPT.SERVICE_IN_LOCK";

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean getDefaultCheckAll() {
        return this.defaultCheckAll;
    }

    public void setDefaultCheckAll(boolean defaultCheckAll) {
        this.defaultCheckAll = defaultCheckAll;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String key) {
        this.sessionKey = key;
    }

    public boolean getFeatureEnabled() {
        return this.featureEnabled;
    }

    public void setFeatureEnabled(boolean featureEnabled) {
        this.featureEnabled = featureEnabled;
    }

    public SessionLockChecker(IObjectRegistry reg) {
        this.mObjectRegistry = reg;
    }

    public IServiceSessionLock getServiceSessionLock() {
        return this.mSessionLock;
    }

    @Override
    public boolean startup() {
        this.mSessionLock = (IServiceSessionLock)this.mObjectRegistry.getInstanceOfType(IServiceSessionLock.class);
        if (this.mSessionLock == null) {
            this.mSessionLock = new ServiceSessionLock();
            this.mObjectRegistry.registerInstance(IServiceSessionLock.class, this.mSessionLock);
        }
        this.mObjectRegistry.registerInstance(SessionLockChecker.class, this);
        return true;
    }

    @Override
    public void shutdown() {
    }

    public int onCheckServiceLock(ProcedureRunner runner) throws Exception {
        if (!this.featureEnabled) {
            return 0;
        }
        ServiceContext context = ServiceContext.createServiceContext(runner.getContext());
        if (this.doSessionLockCheck(context)) {
            context.put("success", false);
            runner.locateTo("CreateResponse");
            return 1;
        }
        return 0;
    }

    public boolean doSessionLockCheck(ServiceContext ct) throws Exception {
        CompositeMap context = ct.getObjectContext();
        ServiceInstance svc = ServiceInstance.getInstance(context);
        CompositeMap svc_config = svc.getServiceConfigData();
        Boolean check_lock = svc_config.getBoolean("checksessionlock");
        if (check_lock == null) {
            check_lock = this.getDefaultCheckAll();
        }
        if (!check_lock.booleanValue()) {
            return false;
        }
        String lock_key = svc_config.getString("lockkey");
        if (lock_key == null) {
            lock_key = this.getSessionKey();
        }
        lock_key = TextParser.parse(lock_key, context);
        String service_name = svc_config.getString("lockservice");
        service_name = service_name == null ? svc.getName() : TextParser.parse(service_name, context);
        IServiceSessionLock ss_lock = this.getServiceSessionLock();
        boolean locked = ss_lock.islocked(lock_key, service_name);
        if (locked) {
            String error_message = svc_config.getString("lockerrormessage");
            if (error_message == null) {
                error_message = this.getErrorMessage();
            }
            error_message = LanguageUtil.getTranslatedMessage(this.mObjectRegistry, error_message, context);
            ErrorMessage msg = new ErrorMessage(null, error_message, null);
            ct.setError(msg.getObjectContext());
            return true;
        }
        ss_lock.lock(lock_key, service_name, 0L);
        ServiceSessionLock.Unlocker unlocker = new ServiceSessionLock.Unlocker(ss_lock, lock_key, service_name);
        svc.addResourceReleaser(unlocker);
        return false;
    }
}

