/*
 * Decompiled with CFR 0.152.
 */
package uncertain.datatype;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import uncertain.datatype.BigDecimalType;
import uncertain.datatype.BooleanType;
import uncertain.datatype.ByteType;
import uncertain.datatype.ClobType;
import uncertain.datatype.ConvertionException;
import uncertain.datatype.DataType;
import uncertain.datatype.DateType;
import uncertain.datatype.DoubleType;
import uncertain.datatype.FloatType;
import uncertain.datatype.IntegerType;
import uncertain.datatype.JavaClassType;
import uncertain.datatype.LongType;
import uncertain.datatype.StringType;
import uncertain.datatype.TimestampType;

public class DataTypeRegistry {
    static DataTypeRegistry default_instance = new DataTypeRegistry();
    HashMap type_map = new HashMap();
    HashMap class_map = new HashMap();

    public static DataTypeRegistry getInstance() {
        return default_instance;
    }

    public DataTypeRegistry() {
        this.type_map.put(new Integer(1), new StringType());
        this.type_map.put(new Integer(12), new StringType());
        this.type_map.put(new Integer(-6), new ByteType());
        this.type_map.put(new Integer(5), new IntegerType());
        this.type_map.put(new Integer(4), new IntegerType());
        this.type_map.put(new Integer(-5), new LongType());
        this.type_map.put(new Integer(16), new BooleanType());
        this.type_map.put(new Integer(6), new FloatType());
        this.type_map.put(new Integer(8), new DoubleType());
        this.type_map.put(new Integer(3), new LongType());
        this.type_map.put(new Integer(2), new LongType());
        this.type_map.put(new Integer(91), new DateType());
        this.type_map.put(new Integer(93), new TimestampType());
        this.type_map.put(new Integer(2005), new ClobType());
        for (DataType type : this.type_map.values()) {
            this.class_map.put(type.getJavaType().getName(), type);
        }
        this.class_map.put(Integer.TYPE.getName(), this.class_map.get("java.lang.Integer"));
        this.class_map.put(Boolean.TYPE.getName(), this.class_map.get("java.lang.Boolean"));
        this.class_map.put(Long.TYPE.getName(), this.class_map.get("java.lang.Long"));
        this.class_map.put(Float.TYPE.getName(), this.class_map.get("java.lang.Float"));
        this.class_map.put(Double.TYPE.getName(), this.class_map.get("java.lang.Double"));
        this.class_map.put(BigDecimal.class.getName(), new BigDecimalType());
        this.class_map.put(Class.class.getName(), new JavaClassType());
        this.class_map.put(Date.class.getName(), new DateType());
        this.class_map.put("date", new DateType());
        this.class_map.put("string", this.class_map.get("java.lang.String"));
    }

    public DataType getDataType(Class cls) {
        return (DataType)this.class_map.get(cls.getName());
    }

    public DataType getDataType(String class_name) {
        return (DataType)this.class_map.get(class_name);
    }

    public DataType getType(int id) {
        return (DataType)this.type_map.get(new Integer(id));
    }

    public DataType getType(Object obj) {
        return this.getType(obj.getClass());
    }

    public Object convert(Object value, Class prefered_class) throws ConvertionException {
        DataType dt = this.getDataType(prefered_class);
        if (dt == null) {
            return null;
        }
        return dt.convert(value);
    }
}

