/*
 * Decompiled with CFR 0.152.
 */
package uncertain.ocm;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.ocm.ArrayAccessor;
import uncertain.ocm.CollectionAccessor;
import uncertain.ocm.CollectionMappable;
import uncertain.ocm.ContainerAccessor;
import uncertain.ocm.FieldAccessor;
import uncertain.ocm.MethodAccessor;
import uncertain.ocm.OCManager;
import uncertain.ocm.ObjectAccessor;

public class MappingRule {
    Class target_class;
    OCManager oc_manager;
    ObjectAccessor[] for_attrib;
    HashMap for_attrib_map;
    HashMap for_element_map;

    public MappingRule(Class _target_class, OCManager _oc_manager) {
        this.target_class = _target_class;
        this.oc_manager = _oc_manager;
        this.for_attrib_map = new HashMap();
    }

    public ObjectAccessor wrapAccessor(ObjectAccessor oac) {
        Class type = oac.getType();
        if (type.isArray()) {
            return new ArrayAccessor(oac);
        }
        if (CompositeMap.class.isAssignableFrom(type)) {
            return new ContainerAccessor(oac);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return new CollectionAccessor(oac);
        }
        return oac;
    }

    public void addMapping(String name, ObjectAccessor oa, boolean from_attribute) {
        oa.setOCManager(this.oc_manager);
        if (oa instanceof CollectionMappable || oa instanceof ContainerAccessor || !from_attribute) {
            if (this.for_element_map == null) {
                this.for_element_map = new HashMap();
            }
            this.for_element_map.put(name, oa);
        } else {
            this.for_attrib_map.put(name, oa);
        }
    }

    public void addMapping(String name, Field field, boolean from_attribute) {
        FieldAccessor fa = new FieldAccessor(name, field);
        ObjectAccessor oa = this.wrapAccessor(fa);
        this.addMapping(name, oa, from_attribute);
    }

    public void addMapping(String name, Method set_method, Method get_method, boolean from_attribute) {
        MethodAccessor ma = new MethodAccessor(name);
        ma.setMethodForGet(get_method);
        ma.setMethodForSet(set_method);
        ObjectAccessor oa = this.wrapAccessor(ma);
        this.addMapping(name, oa, from_attribute);
    }

    void getReady() {
        Collection entries = this.for_attrib_map.values();
        this.for_attrib = new ObjectAccessor[entries.size()];
        Object[] objs = entries.toArray();
        System.arraycopy(objs, 0, this.for_attrib, 0, objs.length);
    }

    public ObjectAccessor[] getAttribMapping() {
        return this.for_attrib;
    }

    public Map getElementMapping() {
        return this.for_element_map;
    }

    public Map getAttributeMapping() {
        return this.for_attrib_map;
    }

    public String toString() {
        return "\r\nMappingRule for " + this.target_class.getName() + "\r\n{\r\nattributes:" + this.for_attrib_map + "\r\nelements:" + this.for_element_map + " \r\n}\r\n";
    }
}

