/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc.trace;

import java.sql.Timestamp;
import java.util.LinkedList;
import uncertain.composite.CompositeMap;
import uncertain.proc.IEntry;
import uncertain.util.resource.ILocatable;
import uncertain.util.resource.Location;

public class TraceElement {
    long enterTime = System.currentTimeMillis();
    long exitTime;
    String sourceName;
    String sourceFile;
    Location sourceLocation;
    LinkedList<TraceElement> childs;
    TraceElement parent;
    static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public TraceElement(String sourceName, ILocatable sourceLocation) {
        this.sourceName = sourceName;
        if (sourceLocation != null) {
            this.sourceFile = sourceLocation.getOriginSource();
            this.sourceLocation = sourceLocation.getOriginLocation();
        }
    }

    public TraceElement(IEntry entry) {
        this(entry.getName(), entry instanceof ILocatable ? (ILocatable)((Object)entry) : null);
    }

    public TraceElement(String name) {
        this.sourceName = name;
    }

    public long getEnterTime() {
        return this.enterTime;
    }

    public void setEnterTime(long enterTime) {
        this.enterTime = enterTime;
    }

    public long getExitTime() {
        return this.exitTime;
    }

    public void setExitTime(long exitTime) {
        this.exitTime = exitTime;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public Location getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(Location sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public TraceElement getParent() {
        return this.parent;
    }

    public void setParent(TraceElement parent) {
        this.parent = parent;
    }

    public void addChild(TraceElement trace) {
        if (this.childs == null) {
            this.childs = new LinkedList();
        }
        this.childs.add(trace);
    }

    private void toSingleLine(StringBuffer buf) {
        buf.append("at ").append(this.sourceName);
        if (this.sourceFile != null) {
            buf.append("(").append(this.sourceFile);
            if (this.sourceLocation != null) {
                buf.append(":").append(this.sourceLocation.getStartLine());
            }
            buf.append(")");
        }
    }

    public String toStackTrace() {
        StringBuffer buf = new StringBuffer();
        this.toSingleLine(buf);
        if (this.parent != null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.parent.toStackTrace());
        }
        return buf.toString();
    }

    public long getDuration() {
        if (this.exitTime < this.enterTime) {
            return 0L;
        }
        return this.exitTime - this.enterTime;
    }

    private void populateTo(CompositeMap entry) {
        entry.put("name", this.getSourceName());
        entry.put("enter_time", new Timestamp(this.getEnterTime()));
        entry.put("exit_time", new Timestamp(this.getExitTime()));
        if (this.sourceFile != null) {
            entry.put("source", this.sourceFile);
        }
        if (this.sourceLocation != null) {
            entry.put("line", (Object)this.sourceLocation.getStartLine());
        }
        entry.put("duration", (Object)this.getDuration());
    }

    public CompositeMap asCompositeMap() {
        CompositeMap entry = new CompositeMap("entry");
        this.populateTo(entry);
        if (this.childs != null) {
            for (TraceElement t : this.childs) {
                entry.addChild(t.asCompositeMap());
            }
        }
        return entry;
    }

    public CompositeMap asCompositeMap(boolean leaf_node_only, boolean ignore_duration_zero) {
        CompositeMap root = new CompositeMap("entry");
        if (!leaf_node_only) {
            this.populateTo(root);
        }
        if (this.childs != null) {
            for (TraceElement t : this.childs) {
                t.addToCompositeMap(root, leaf_node_only, ignore_duration_zero);
            }
        }
        return root;
    }

    private void addToCompositeMap(CompositeMap root, boolean leaf_node_only, boolean ignore_duration_zero) {
        boolean should_add_this = true;
        if (leaf_node_only && this.childs != null) {
            should_add_this = false;
        }
        if (ignore_duration_zero && this.getDuration() == 0L) {
            should_add_this = false;
        }
        CompositeMap to_add = root;
        if (should_add_this) {
            CompositeMap entry = new CompositeMap("entry");
            this.populateTo(entry);
            root.addChild(entry);
            to_add = entry;
        }
        if (this.childs != null) {
            for (TraceElement t : this.childs) {
                t.addToCompositeMap(to_add, leaf_node_only, ignore_duration_zero);
            }
        }
    }

    public void clear() {
        if (this.childs != null) {
            for (TraceElement e : this.childs) {
                e.clear();
            }
        }
    }
}

