/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.bill99.pos;

import aurora.plugin.bill99.Configuration;
import aurora.plugin.bill99.pos.EXT;
import aurora.plugin.bill99.pos.Pkipair;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.BufferedWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class OQSFeedback
extends AbstractEntry {
    private String responseCode;
    private String reqTime;
    private String respTime;
    private String orderId;
    private String merchantId;
    private String merchantName;
    private String amt;
    private String amt2;
    private String amt3;
    private String amt4;
    private EXT[] exts;

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        HttpServletRequest request = serviceInstance.getRequest();
        request.setCharacterEncoding("GBK");
        this.responseCode = this.getValue(context, this.getResponseCode());
        this.reqTime = this.getValue(context, this.getReqTime());
        this.respTime = this.getValue(context, this.getRespTime());
        this.orderId = this.getValue(context, this.getOrderId());
        this.merchantId = this.getValue("posMerchantId");
        this.merchantName = this.getValue("posMerchantName");
        this.amt = this.getValue(context, this.getAmt());
        this.amt2 = this.getValue(context, this.getAmt2());
        this.amt3 = this.getValue(context, this.getAmt3());
        this.amt4 = this.getValue(context, this.getAmt4());
        StringBuffer sbr = new StringBuffer();
        sbr.append("<MessageContent>");
        sbr.append("<reqTime>");
        sbr.append(this.reqTime);
        sbr.append("</reqTime>");
        sbr.append("<respTime>");
        sbr.append(this.respTime);
        sbr.append("</respTime>");
        sbr.append("<responseCode>");
        sbr.append(this.responseCode);
        sbr.append("</responseCode>");
        sbr.append("<message>");
        sbr.append("<orderId>");
        sbr.append(this.orderId);
        sbr.append("</orderId>");
        sbr.append("<merchantId>");
        sbr.append(this.merchantId);
        sbr.append("</merchantId>");
        sbr.append("<merchantName>" + this.merchantName + "</merchantName>");
        sbr.append("<amt>" + this.amt + "</amt>");
        sbr.append("<amt2>" + this.amt2 + "</amt2>");
        sbr.append("<amt3>" + this.amt3 + "</amt3>");
        sbr.append("<amt4>" + this.amt4 + "</amt4>");
        StringBuffer extXml = this.createExtXml(context);
        sbr.append(extXml);
        sbr.append("</message>");
        sbr.append("</MessageContent>");
        Pkipair pk = new Pkipair();
        String signMAC = pk.signMsg(sbr.toString());
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><ResponseMessage><MAC>" + signMAC.replaceAll("\r", "").replaceAll("\n", "") + "</MAC>" + sbr.toString() + "</ResponseMessage>";
        HttpServletResponse response = serviceInstance.getResponse();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html;charset=gbk");
        BufferedWriter outW = new BufferedWriter(response.getWriter());
        String str = new String(xml.getBytes("gbk"));
        outW.write(str);
        outW.flush();
        outW.close();
    }

    private StringBuffer createExtXml(CompositeMap context) {
        StringBuffer sbr = new StringBuffer();
        sbr.append("<ext>");
        EXT[] exts = this.getExts();
        if (exts != null) {
            for (int i = 0; i < exts.length; ++i) {
                String property = this.getValue(context, exts[i].getPropertyName());
                if ("".equals(property)) continue;
                String value = this.getValue(context, exts[i].getValue());
                String chnName = this.getValue(context, exts[i].getChnName());
                StringBuffer s = new StringBuffer();
                s.append("<");
                s.append(property);
                s.append(">");
                s.append("<value>");
                s.append(value);
                s.append("</value>");
                s.append("<chnName>");
                s.append(chnName);
                s.append("</chnName>");
                s.append("</");
                s.append(property);
                s.append(">");
                sbr.append(s);
            }
        }
        sbr.append("</ext>");
        return sbr;
    }

    private String getValue(CompositeMap context, String key) {
        if (key != null) {
            return TextParser.parse((String)key, (CompositeMap)context);
        }
        return "";
    }

    private String getValue(String key) {
        String value = Configuration.getInstance().getValue(key);
        return value == null ? "" : value;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public String getReqTime() {
        return this.reqTime;
    }

    public void setReqTime(String reqTime) {
        this.reqTime = reqTime;
    }

    public String getRespTime() {
        return this.respTime;
    }

    public void setRespTime(String respTime) {
        this.respTime = respTime;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getAmt() {
        return this.amt;
    }

    public void setAmt(String amt) {
        this.amt = amt;
    }

    public String getAmt2() {
        return this.amt2;
    }

    public void setAmt2(String amt2) {
        this.amt2 = amt2;
    }

    public String getAmt3() {
        return this.amt3;
    }

    public void setAmt3(String amt3) {
        this.amt3 = amt3;
    }

    public String getAmt4() {
        return this.amt4;
    }

    public void setAmt4(String amt4) {
        this.amt4 = amt4;
    }

    public EXT[] getExts() {
        return this.exts;
    }

    public void setExts(EXT[] exts) {
        this.exts = exts;
    }
}

