/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.dataimport;

import aurora.database.service.SqlServiceContext;
import aurora.plugin.csv.CsvParse;
import aurora.plugin.poi.eventmodel.XLSParse;
import aurora.plugin.poi.eventmodel.XLSXParse;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.UncertainEngine;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class ImportExcel
extends AbstractEntry {
    public static final String XLS_KEY = ".xls";
    public static final String XLSX_KEY = ".xlsx";
    public static final String CSV_KEY = ".csv";
    public static final String TXT_KEY = ".txt";
    public String fileName;
    public String separator = ",";
    public String header_id;
    public String user_id = "${/session/@user_id}";
    public String template_code;
    public String job_id;
    public String attribute1;
    public String attribute2;
    public String attribute3;
    public String attribute4;
    public String attribute5;
    public String dataSourceName;
    UncertainEngine mUncertainEngine;
    Connection conn;

    public ImportExcel(UncertainEngine uncertainEngine) {
        this.mUncertainEngine = uncertainEngine;
    }

    public String getTemplate_code() {
        return this.template_code;
    }

    public void setTemplate_code(String template_code) {
        this.template_code = template_code;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        this.validatePara(context);
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        SqlServiceContext sqlServiceContext = SqlServiceContext.createSqlServiceContext((CompositeMap)context);
        this.conn = sqlServiceContext.getNamedConnection(this.dataSourceName);
        if (this.conn == null) {
            sqlServiceContext.initConnection(this.mUncertainEngine.getObjectRegistry(), this.dataSourceName);
            this.conn = sqlServiceContext.getNamedConnection(this.dataSourceName);
        }
        this.saveHead();
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload up = new ServletFileUpload((FileItemFactory)factory);
        List items = up.parseRequest(serviceInstance.getRequest());
        for (FileItem fileItem : items) {
            if (fileItem.isFormField()) continue;
            this.fileName = fileItem.getName();
            String suffix = this.fileName.substring(this.fileName.lastIndexOf("."));
            this.parseFile(fileItem.getInputStream(), suffix.toLowerCase(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveHead() throws SQLException {
        Statement cstm = null;
        String headSql = "fnd_interface_load_pkg.ins_fnd_interface_headers(?,?,?,?,?,?,?,?,?,?,?)";
        try {
            cstm = this.conn.prepareCall("{call " + headSql + "}");
            cstm.setLong(1, new Long(this.header_id));
            if (this.job_id == null) {
                cstm.setNull(2, 2);
            } else {
                cstm.setLong(2, new Long(this.job_id));
            }
            cstm.setString(3, "NEW");
            cstm.setString(4, this.user_id);
            cstm.setString(5, this.fileName);
            if (this.template_code == null) {
                cstm.setNull(6, 12);
            } else {
                cstm.setString(6, this.template_code);
            }
            if (this.attribute1 == null) {
                cstm.setNull(7, 12);
            } else {
                cstm.setString(7, this.attribute1);
            }
            if (this.attribute2 == null) {
                cstm.setNull(8, 12);
            } else {
                cstm.setString(8, this.attribute2);
            }
            if (this.attribute3 == null) {
                cstm.setNull(9, 12);
            } else {
                cstm.setString(9, this.attribute3);
            }
            if (this.attribute4 == null) {
                cstm.setNull(10, 12);
            } else {
                cstm.setString(10, this.attribute4);
            }
            if (this.attribute5 == null) {
                cstm.setNull(11, 12);
            } else {
                cstm.setString(11, this.attribute5);
            }
            cstm.execute();
        }
        finally {
            if (cstm != null) {
                cstm.close();
            }
        }
    }

    void parseFile(InputStream is, String suffix, ImportExcel importExcel) throws Exception {
        if (XLS_KEY.equals(suffix)) {
            XLSParse xlsParse = new XLSParse();
            xlsParse.parseFile(is, importExcel);
        }
        if (XLSX_KEY.equals(suffix)) {
            XLSXParse xlsxParse = new XLSXParse();
            xlsxParse.parseFile(is, importExcel);
        } else if (CSV_KEY.equals(suffix) || TXT_KEY.equals(suffix)) {
            if (this.separator == null) {
                throw new IllegalArgumentException("separator is undefined");
            }
            CsvParse cvsParser = new CsvParse();
            cvsParser.parseFile(is, importExcel);
        }
    }

    void validatePara(CompositeMap context) {
        this.header_id = TextParser.parse((String)this.header_id, (CompositeMap)context);
        if (this.header_id == null && "".equals(this.header_id)) {
            throw new IllegalArgumentException("header_id is undefined");
        }
        this.user_id = TextParser.parse((String)this.user_id, (CompositeMap)context);
        if (this.user_id == null && "".equals(this.user_id)) {
            throw new IllegalArgumentException("user_id is undefined");
        }
        this.template_code = TextParser.parse((String)this.template_code, (CompositeMap)context);
        this.job_id = TextParser.parse((String)this.job_id, (CompositeMap)context);
        this.attribute1 = TextParser.parse((String)this.attribute1, (CompositeMap)context);
        this.attribute2 = TextParser.parse((String)this.attribute2, (CompositeMap)context);
        this.attribute3 = TextParser.parse((String)this.attribute3, (CompositeMap)context);
        this.attribute4 = TextParser.parse((String)this.attribute4, (CompositeMap)context);
        this.attribute5 = TextParser.parse((String)this.attribute5, (CompositeMap)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLine(CompositeMap data, int rownum) throws SQLException {
        if (data.getLong((Object)"maxCell") == null) {
            return;
        }
        int maxcell = data.getInt((Object)"maxCell");
        boolean is_null = true;
        for (int i = 0; i < maxcell; ++i) {
            String valueString = data.getString((Object)("C" + i));
            if (valueString == null && "".equals(valueString)) continue;
            is_null = false;
            break;
        }
        if (is_null) {
            return;
        }
        StringBuffer lineSql = new StringBuffer("fnd_interface_load_pkg.ins_fnd_interface_lines(?,?,?,?,?,?,?");
        for (int i = 0; i < maxcell; ++i) {
            lineSql.append(",?");
        }
        lineSql.append(")");
        Statement cstm = null;
        try {
            cstm = this.conn.prepareCall("{call " + lineSql + "}");
            cstm.setLong(1, new Long(this.header_id));
            cstm.setNull(2, 12);
            cstm.setNull(3, 12);
            cstm.setString(4, this.user_id);
            cstm.setLong(5, rownum);
            cstm.setNull(6, 12);
            cstm.setNull(7, 2);
            for (int i = 0; i < maxcell; ++i) {
                String valueString = data.getString((Object)("C" + i));
                if (valueString == null) {
                    cstm.setNull(8 + i, 12);
                    continue;
                }
                cstm.setString(8 + i, valueString);
            }
            cstm.execute();
        }
        finally {
            if (cstm != null) {
                cstm.close();
            }
        }
    }

    public String getHeader_id() {
        return this.header_id;
    }

    public void setHeader_id(String header_id) {
        this.header_id = header_id;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getUser_id() {
        return this.user_id;
    }

    public void setUser_id(String user_id) {
        this.user_id = user_id;
    }

    public String getJob_id() {
        return this.job_id;
    }

    public void setJob_id(String job_id) {
        this.job_id = job_id;
    }

    public String getAttribute1() {
        return this.attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1;
    }

    public String getAttribute2() {
        return this.attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2;
    }

    public String getAttribute3() {
        return this.attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3;
    }

    public String getAttribute4() {
        return this.attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4;
    }

    public String getAttribute5() {
        return this.attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5;
    }
}

