/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.features;

import aurora.application.features.ILookupCodeProvider;
import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.Relation;
import aurora.database.IResultSetConsumer;
import aurora.database.profile.IDatabaseFactory;
import aurora.service.ServiceThreadLocal;
import java.util.Iterator;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.IObjectRegistry;

public class CacheBasedLookUpField {
    private IDatabaseFactory factory;
    private IObjectRegistry mRegistry;
    private ILookupCodeProvider lookupProvider;

    public CacheBasedLookUpField(IDatabaseFactory factory, IObjectRegistry registry) {
        this.factory = factory;
        this.mRegistry = registry;
    }

    public void onPrepareBusinessModel(BusinessModel model) {
        this.lookupProvider = (ILookupCodeProvider)this.mRegistry.getInstanceOfType(ILookupCodeProvider.class);
        if (this.lookupProvider == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, ILookupCodeProvider.class, this.getClass().getCanonicalName());
        }
        Field[] fields = model.getFields();
        if (fields == null) {
            return;
        }
        Field field = null;
        Field refield = null;
        String lookUpField = null;
        int l = fields.length;
        block0: for (int i = 0; i < l; ++i) {
            field = fields[i];
            if (field.isReferenceField()) {
                CompositeMap cmap = (CompositeMap)field.getReferredField().getObjectContext().clone();
                cmap.copy(field.getObjectContext());
                refield = Field.getInstance(cmap);
            } else {
                refield = field;
            }
            lookUpField = refield.getLookUpField();
            if (lookUpField == null || refield.getLookUpCode() == null) continue;
            for (int j = 0; j < l; ++j) {
                Field f = fields[j];
                if (!f.getName().equalsIgnoreCase(lookUpField) || f.isExpression()) continue;
                f.setForQuery(false);
                f.setForSelect(false);
                continue block0;
            }
        }
        model.makeReady();
    }

    public void postFetchResultSet(BusinessModel model, IResultSetConsumer consumer) throws Exception {
        Object result = consumer.getResult();
        if (!(result instanceof CompositeMap)) {
            return;
        }
        Field[] fields = model.getFields();
        if (fields == null) {
            return;
        }
        Field field2 = null;
        Field refield = null;
        String alias = model.getAlias();
        String idFieldName = null;
        CompositeMap dbProperties = this.factory.getProperties();
        CompositeMap currentContext = new CompositeMap();
        if (ServiceThreadLocal.getCurrentThreadContext() != null) {
            currentContext = ServiceThreadLocal.getCurrentThreadContext();
        }
        String language = TextParser.parse("${" + dbProperties.getString("language_path") + "}", currentContext);
        for (Field field2 : fields) {
            if (field2.isReferenceField()) {
                CompositeMap cmap = (CompositeMap)field2.getReferredField().getObjectContext().clone();
                cmap.copy(field2.getObjectContext());
                refield = Field.getInstance(cmap);
                Relation relation = model.getRelation(field2.getRelationName());
                alias = relation.getReferenceAlias();
                if (alias == null) {
                    alias = field2.getRelationName();
                }
                idFieldName = field2.getSourceField();
            } else {
                refield = field2;
                idFieldName = refield.getName();
            }
            String lookupfiled = refield.getLookUpField();
            String lookupcode = refield.getLookUpCode();
            if (lookupfiled == null || lookupcode == null) continue;
            this.addCodeValueName((CompositeMap)result, lookupfiled, lookupcode, idFieldName, language, field2.getExpression());
        }
    }

    private void addCodeValueName(CompositeMap data, String lookupfiled, String lookupcode, String srcFieldName, String language, String expression) throws Exception {
        if (data == null) {
            return;
        }
        if (data.getChilds() == null) {
            this.addRecordCodeValueName(data, lookupfiled, lookupcode, srcFieldName, language);
            return;
        }
        Iterator it = data.getChildIterator();
        while (it.hasNext()) {
            CompositeMap record = (CompositeMap)it.next();
            this.addRecordCodeValueName(record, lookupfiled, lookupcode, srcFieldName, language);
        }
    }

    private void addRecordCodeValueName(CompositeMap data, String lookupfiled, String lookupcode, String srcFieldName, String language) throws Exception {
        String code_value = data.getString(srcFieldName);
        if (code_value == null) {
            return;
        }
        String prompt = this.lookupProvider.getLookupPrompt(language, lookupcode, code_value);
        if (prompt == null) {
            return;
        }
        data.put(lookupfiled, prompt);
    }
}

