/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component;

import aurora.presentation.BuildSession;
import aurora.presentation.IViewBuilder;
import aurora.presentation.PresentationManager;
import aurora.presentation.ViewComponentPackage;
import aurora.presentation.ViewConfigurationError;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import aurora.presentation.component.ViewPartTagCreator;
import java.io.File;
import java.io.IOException;
import uncertain.composite.CompositeMap;
import uncertain.ocm.ISingleton;
import uncertain.util.template.ITagCreatorRegistry;
import uncertain.util.template.TagCreatorRegistry;
import uncertain.util.template.TagTemplateParser;
import uncertain.util.template.TextTemplate;

public class TemplateRenderer
implements IViewBuilder,
ISingleton {
    public static final String KEY_PACKAGE = "package";
    public static final String KEY_TEMPLATE = "template";
    public static final String KEY_TITLE = "title";
    public static final String KEY_INDEX_FIELD = "indexfield";
    public static final String KEY_CONTENT_TYPE = "contenttype";
    public static final String KEY_LABEL_SEPARATOR = "labelseparator";
    public static final String KEY_MANIFEST = "manifest";
    private static final String DEFAULT_INDEX_FIELD = "id";
    TagTemplateParser mTemplateParser = new TagTemplateParser();

    protected static TextTemplate getViewTemplate(BuildSession session, ViewContext view_context, ITagCreatorRegistry tag_reg) throws ViewCreationException, IOException {
        PresentationManager prm = session.getPresentationManager();
        CompositeMap view = view_context.getView();
        String name = view.getString(KEY_TEMPLATE);
        if (name == null) {
            throw new ViewConfigurationError("'template' must be set");
        }
        if (name.indexOf(46) < 0) {
            name = name + ".tplt";
        }
        ViewComponentPackage pkg = null;
        String pkg_name = view.getString(KEY_PACKAGE);
        if (pkg_name == null) {
            pkg = session.getCurrentPackage();
        } else {
            pkg = session.getPresentationManager().getPackage(pkg_name);
            if (pkg == null) {
                throw new ViewCreationException("Can't load package " + pkg_name);
            }
        }
        File template_file = pkg.getTemplateFile(session.getTheme(), name);
        if (template_file == null) {
            throw new ViewCreationException("Can't load template " + name);
        }
        TagTemplateParser parser = prm.getTemplateParser();
        return parser.buildTemplate(template_file, tag_reg);
    }

    protected ITagCreatorRegistry createTagCreatorRegistry(BuildSession session, ViewContext view_context) {
        TagCreatorRegistry reg = new TagCreatorRegistry();
        CompositeMap view = view_context.getView();
        String indexField = view.getString(KEY_INDEX_FIELD, DEFAULT_INDEX_FIELD);
        ViewPartTagCreator creator = new ViewPartTagCreator(session, view_context, indexField);
        reg.setDefaultCreator(creator);
        reg.setParent(session.getTagCreatorRegistry());
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        ITagCreatorRegistry reg = this.createTagCreatorRegistry(session, view_context);
        TextTemplate template = TemplateRenderer.getViewTemplate(session, view_context, reg);
        try {
            template.createOutput(session.getWriter(), view_context.getModel());
        }
        finally {
            template.clear();
        }
    }

    @Override
    public String[] getBuildSteps(ViewContext context) {
        return null;
    }
}

