/*
 * Decompiled with CFR 0.152.
 */
package uncertain.datatype;

import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import uncertain.datatype.AbstractDataType;
import uncertain.datatype.ConvertionException;
import uncertain.datatype.DataType;

public class ClobType
extends AbstractDataType
implements DataType {
    @Override
    public Class getJavaType() {
        return Clob.class;
    }

    @Override
    public int getSqlType() {
        return 2005;
    }

    @Override
    public Object getObject(CallableStatement stmt, int id) throws SQLException {
        return stmt.getClob(id);
    }

    @Override
    public Object getObject(ResultSet rs, int id) throws SQLException {
        Clob aClob = rs.getClob(id);
        if (aClob == null) {
            return null;
        }
        try {
            int n;
            StringBuffer buf = new StringBuffer();
            Reader reader = aClob.getCharacterStream();
            if (reader == null) {
                return null;
            }
            while ((n = reader.read()) != -1) {
                buf.append((char)n);
            }
            return buf.toString();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void registerParameter(CallableStatement stmt, int id) throws SQLException {
        stmt.registerOutParameter(id, 2005);
    }

    @Override
    public void setParameter(PreparedStatement stmt, int id, Object value) throws SQLException {
        if (value == null) {
            stmt.setNull(id, this.getSqlType());
        } else if (value instanceof Clob) {
            stmt.setClob(id, (Clob)value);
        } else {
            stmt.setString(id, value.toString());
        }
    }

    @Override
    public Object convert(Object value) throws ConvertionException {
        return value;
    }
}

