/*
 * Decompiled with CFR 0.152.
 */
package uncertain.datatype;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.text.Format;
import java.text.ParseException;
import uncertain.datatype.StringType;

public class JavaClassType
extends StringType {
    @Override
    public Class getJavaType() {
        return Class.class;
    }

    @Override
    public Object getObject(CallableStatement stmt, int id) throws SQLException {
        Object cls_name = super.getObject(stmt, id);
        return this.convert(cls_name);
    }

    @Override
    public Object convert(Object value) {
        if (value != null && value instanceof String) {
            try {
                return Class.forName((String)value);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Can't find class " + ex.getMessage());
            }
        }
        return null;
    }

    @Override
    public Object parseObject(String strValue, Format format) throws ParseException {
        return this.convert(strValue);
    }
}

