/*
 * Decompiled with CFR 0.152.
 */
package uncertain.ocm;

import java.lang.reflect.Array;
import java.util.List;
import java.util.ListIterator;
import uncertain.composite.CompositeMap;
import uncertain.ocm.CollectionMappable;
import uncertain.ocm.ObjectAccessor;

public class ArrayAccessor
extends CollectionMappable {
    Class component_type;

    public ArrayAccessor(ObjectAccessor oa) {
        super(oa);
        this.component_type = oa.getType().getComponentType();
    }

    @Override
    public Class getType() {
        return this.component_type;
    }

    @Override
    public Object getObjectToSet(List collection) {
        ListIterator it = collection.listIterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (this.component_type.isAssignableFrom(obj.getClass())) continue;
            it.remove();
        }
        Object new_array = Array.newInstance(this.component_type, collection.size());
        System.arraycopy(collection.toArray(), 0, new_array, 0, collection.size());
        return new_array;
    }

    @Override
    public void populateContainer(CompositeMap container, Object value) {
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            Object obj = Array.get(value, i);
            CompositeMap map = this.oc_manager.createContainer(obj);
            if (map == null) continue;
            container.addChild(map);
        }
    }
}

