/*
 * Decompiled with CFR 0.152.
 */
package uncertain.ocm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.ocm.ClassAnalyzer;
import uncertain.ocm.IChildContainerAcceptable;
import uncertain.ocm.IMappingHandle;
import uncertain.ocm.IObjectMapper;
import uncertain.ocm.MappingRule;
import uncertain.ocm.NamingUtil;
import uncertain.ocm.OCMEventFactory;
import uncertain.ocm.OCManager;
import uncertain.ocm.ObjectAccessor;

public class ReflectionMapper
implements IObjectMapper {
    OCManager oc_manager;
    ClassAnalyzer class_analyzer;
    HashMap rule_map;

    public ReflectionMapper(OCManager _oc_manager) {
        this.oc_manager = _oc_manager;
        this.rule_map = new HashMap(500);
        this.class_analyzer = new ClassAnalyzer(_oc_manager);
    }

    public MappingRule getMappingRule(Class type) {
        MappingRule rule = (MappingRule)this.rule_map.get(type);
        if (rule == null) {
            rule = this.createMappingRule(type);
        }
        return rule;
    }

    public void setMappingRule(Class type, MappingRule rule) {
        this.rule_map.put(type, rule);
    }

    public MappingRule createMappingRule(Class type) {
        MappingRule rule = this.class_analyzer.analyze(type);
        this.rule_map.put(type, rule);
        if (this.oc_manager.isEventEnable()) {
            this.oc_manager.fireEvent(OCMEventFactory.newMappingRuleLoadedEvent(this, rule));
        }
        return rule;
    }

    @Override
    public void toObject(CompositeMap map, Object target) {
        this.toObject(map, target, this.oc_manager);
    }

    public void toObject(CompositeMap map, Object target, IMappingHandle handle) {
        MappingRule rule = this.getMappingRule(target.getClass());
        if (rule == null) {
            return;
        }
        ObjectAccessor[] for_attrib = rule.getAttribMapping();
        for (int i = 0; i < for_attrib.length; ++i) {
            ObjectAccessor oa = for_attrib[i];
            try {
                Object value = map.get(oa.getFieldName());
                if (value == null) continue;
                oa.writeToObject(target, value);
                continue;
            }
            catch (Exception ex) {
                this.oc_manager.handleException("error when populate field " + oa.getFieldName(), ex);
            }
        }
        Map for_element = rule.getElementMapping();
        if (for_element == null) {
            return;
        }
        boolean acceptUnknownContainer = handle.acceptUnknownContainer();
        Iterator it = map.getChildIterator();
        if (it != null) {
            while (it.hasNext()) {
                CompositeMap element = (CompositeMap)it.next();
                String name = element.getName();
                if (name == null) continue;
                ObjectAccessor oa = (ObjectAccessor)for_element.get(name = NamingUtil.toIdentifier(name));
                if (oa != null) {
                    try {
                        if (oa.acceptContainer()) {
                            oa.writeToObject(target, element);
                            continue;
                        }
                        Object child_obj = this.oc_manager.createObject(element, handle);
                        if (child_obj == null) continue;
                        oa.writeToObject(target, child_obj);
                    }
                    catch (Exception ex) {
                        this.oc_manager.handleException("error when populate field " + oa.getFieldName(), ex);
                    }
                    continue;
                }
                if (target instanceof IChildContainerAcceptable) {
                    ((IChildContainerAcceptable)target).addChild(element);
                    continue;
                }
                if (!acceptUnknownContainer) continue;
                handle.getUnknownContainer(element);
            }
        }
    }

    @Override
    public void toContainer(Object target, CompositeMap map) {
        MappingRule rule = this.getMappingRule(target.getClass());
        if (rule == null) {
            return;
        }
        ObjectAccessor[] for_attrib = rule.getAttribMapping();
        for (int i = 0; i < for_attrib.length; ++i) {
            ObjectAccessor oa = for_attrib[i];
            try {
                Object value = oa.readFromObject(target);
                map.put(oa.getMappedName(), value);
                continue;
            }
            catch (Exception ex) {
                this.oc_manager.handleException("error when reading field " + oa.getFieldName(), ex);
            }
        }
    }
}

