/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.cache;

import aurora.application.features.cache.CacheProvider;
import java.util.logging.Level;
import uncertain.cache.INamedCacheFactory;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.IObjectRegistry;

public class PeriodModeCacheProvider
extends CacheProvider {
    protected int refreshInterval = -1;
    private Thread periodThread;

    public PeriodModeCacheProvider(IObjectRegistry registry, INamedCacheFactory cacheFactory) {
        super(registry, cacheFactory);
    }

    @Override
    public void initialize() {
        if (this.refreshInterval == -1) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "refreshInterval");
        }
        super.initialize();
        this.executePeriodMode();
    }

    private void executePeriodMode() {
        if (this.refreshInterval > 0) {
            this.periodThread = new Thread(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            1.sleep(PeriodModeCacheProvider.this.refreshInterval);
                            PeriodModeCacheProvider.this.reload();
                        }
                    }
                    catch (Exception e) {
                        PeriodModeCacheProvider.this.logger.log(Level.SEVERE, "", e);
                        throw new RuntimeException(e);
                    }
                }
            };
            this.periodThread.start();
        }
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public void onShutdown() {
        if (this.periodThread != null && this.periodThread.isAlive()) {
            this.periodThread.interrupt();
        }
    }
}

