/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.task;

import aurora.database.service.BusinessModelService;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class Task
extends AbstractEntry {
    private IDatabaseServiceFactory mDatabaseServiceFactory;
    private String bm;
    private String taskName;
    private String taskDescription;
    private String executorInstance;
    private String procFilePath;
    private String procContent;
    private String context;
    private int priority;
    private String taskType;
    private String sql;

    public Task(IDatabaseServiceFactory databaseServiceFactory) {
        this.mDatabaseServiceFactory = databaseServiceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        if (this.bm == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "bm");
        }
        this.bm = TextParser.parse(this.bm, context);
        if (this.taskType == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "taskType");
        }
        this.taskType = TextParser.parse(this.taskType, context);
        if ("JAVA".equals(this.taskType)) {
            if (this.procFilePath == null && this.procContent == null) {
                throw BuiltinExceptionFactory.createOneAttributeMissing(this, "procFilePath,procContent");
            }
            if (this.procFilePath != null && this.procContent != null) {
                throw BuiltinExceptionFactory.createConflictAttributesExcepiton(this, "procFilePath,procContent");
            }
            this.procFilePath = TextParser.parse(this.procFilePath, context);
            this.procContent = TextParser.parse(this.procContent, context);
        }
        if ("PROCEDURE".equals(this.taskType) || "FUNCTION".equals(this.taskType)) {
            if (this.sql == null) {
                throw BuiltinExceptionFactory.createAttributeMissing(this, "taskType");
            }
            this.sql = TextParser.parse(this.sql, context);
        }
        SqlServiceContext sqlServiceContext = null;
        try {
            sqlServiceContext = this.mDatabaseServiceFactory.createContextWithConnection();
            CompositeMap parameters = context.getChild("parameter");
            if (parameters == null) {
                parameters = new CompositeMap("parameter");
                context.addChild(parameters);
            }
            parameters.put("task_name", this.taskName);
            parameters.put("task_description", this.taskDescription);
            parameters.put("executor_instance", this.executorInstance);
            parameters.put("proc_file_path", this.procFilePath);
            parameters.put("proc_content", this.procContent);
            parameters.put("context", context.toXML());
            parameters.put("priority", (Object)this.priority);
            parameters.put("task_type", this.taskType);
            parameters.put("sql", this.sql);
            BusinessModelService businessModelService = this.mDatabaseServiceFactory.getModelService(this.bm, runner.getContext());
            businessModelService.execute(parameters);
        }
        finally {
            if (sqlServiceContext != null) {
                sqlServiceContext.freeConnection();
            }
        }
    }

    public String getBm() {
        return this.bm;
    }

    public void setBm(String bm) {
        this.bm = bm;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public void setTaskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
    }

    public String getExecutorInstance() {
        return this.executorInstance;
    }

    public void setExecutorInstance(String executorInstance) {
        this.executorInstance = executorInstance;
    }

    public String getProcFilePath() {
        return this.procFilePath;
    }

    public void setProcFilePath(String procFilePath) {
        this.procFilePath = procFilePath;
    }

    public String getProcContent() {
        return this.procContent;
    }

    public void setProcContent(String procContent) {
        this.procContent = procContent;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }
}

