/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.task;

import aurora.database.service.BusinessModelService;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.service.IServiceFactory;
import aurora.service.ServiceInvoker;
import aurora.service.ServiceThreadLocal;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.sql.DataSource;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;

public class TaskHandler
extends AbstractLocatableObject {
    private IObjectRegistry mRegistry;
    private String queryTaskBM;
    private String finishTaskBM;
    private int tryTime = 10;
    private IDatabaseServiceFactory databaseServiceFactory;
    private DataSource dataSource;
    private IProcedureManager procedureManager;
    private IServiceFactory serviceFactory;
    private ILogger logger;
    private boolean running = true;
    private Thread taskThread;

    public TaskHandler(IObjectRegistry registry) {
        this.mRegistry = registry;
    }

    public void onInitialize() {
        this.logger = LoggingContext.getLogger(this.getClass().getCanonicalName(), this.mRegistry);
        if (this.queryTaskBM == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "queryTaskBM");
        }
        if (this.finishTaskBM == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "finishTaskBM");
        }
        this.dataSource = (DataSource)this.mRegistry.getInstanceOfType(DataSource.class);
        if (this.dataSource == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, DataSource.class, this.getClass().getName());
        }
        this.databaseServiceFactory = (IDatabaseServiceFactory)this.mRegistry.getInstanceOfType(IDatabaseServiceFactory.class);
        if (this.databaseServiceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IDatabaseServiceFactory.class, this.getClass().getName());
        }
        this.procedureManager = (IProcedureManager)this.mRegistry.getInstanceOfType(IProcedureManager.class);
        if (this.procedureManager == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IProcedureManager.class, this.getClass().getName());
        }
        this.serviceFactory = (IServiceFactory)this.mRegistry.getInstanceOfType(IServiceFactory.class);
        if (this.serviceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IServiceFactory.class, this.getClass().getName());
        }
        this.taskThread = new Thread(){

            @Override
            public void run() {
                try {
                    TaskHandler.this.loopRun();
                }
                catch (Exception e) {
                    TaskHandler.this.logger.log(Level.SEVERE, "", e);
                }
            }
        };
        this.taskThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    TaskHandler.this.running = false;
                    TaskHandler.this.onShutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void loopRun() throws Exception {
        int failedCount = 0;
        while (this.running) {
            CompositeMap task = new CompositeMap();
            CompositeMap context = new CompositeMap();
            try {
                this.executeBM(this.queryTaskBM, context, task);
                if (task == null || task.isEmpty()) {
                    Thread.sleep(1000L);
                    continue;
                }
                Object task_id = task.get("task_id");
                if (task_id == null || "null".equals(task_id)) {
                    Thread.sleep(1000L);
                    continue;
                }
                String strContext = task.getString("context");
                if (strContext != null && !"".equals(strContext)) {
                    context = new CompositeLoader().loadFromString(strContext);
                    this.clearInstance(context);
                }
                ServiceThreadLocal.setCurrentThreadContext(context);
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, "", e);
                if (++failedCount <= this.tryTime) continue;
                break;
            }
            failedCount = 0;
            CompositeMap parameter = (CompositeMap)task.clone();
            try {
                this.executeTask(task, parameter);
            }
            catch (Throwable e) {
                parameter.put("exception", this.getFullStackTrace(e));
            }
            try {
                this.executeBM(this.finishTaskBM, context, parameter);
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, "", e);
            }
            ServiceThreadLocal.remove();
        }
    }

    public void executeTask(CompositeMap task, CompositeMap parameter) throws Exception {
        CompositeLoader loader = new CompositeLoader();
        CompositeMap context = ServiceThreadLocal.getCurrentThreadContext();
        int task_id = task.getInt("task_id");
        String task_type = task.getString("task_type");
        String proc_file_path = task.getString("proc_file_path");
        String proc_content = task.getString("proc_content");
        String sql = task.getString("sql");
        if (task_id == 0) {
            throw BuiltinExceptionFactory.createAttributeMissing(null, "task_id");
        }
        if ("JAVA".equals(task_type)) {
            if (proc_file_path != null && !proc_file_path.equals("")) {
                this.executeProc(proc_file_path, task_id, context);
            } else {
                if (proc_content == null || "".equals(proc_content)) {
                    throw BuiltinExceptionFactory.createOneAttributeMissing(null, "proc_file_path,proc_content");
                }
                CompositeMap procedure_config = loader.loadFromString(proc_content);
                this.executeProc(procedure_config, task_id, context);
            }
        } else if ("PROCEDURE".equals(task_type)) {
            if (sql == null || "".equals(sql)) {
                throw BuiltinExceptionFactory.createAttributeMissing(null, "sql");
            }
            this.execDbProc(context, sql);
        } else if ("FUNCTION".equals(task_type)) {
            if (sql == null || "".equals(sql)) {
                throw BuiltinExceptionFactory.createAttributeMissing(null, "sql");
            }
            this.execDbFun(context, sql);
        } else {
            throw new IllegalArgumentException("The " + task_type + " is not supported!");
        }
    }

    private void clearInstance(CompositeMap context) {
        if (context == null) {
            return;
        }
        Iterator it = context.entrySet().iterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            if (!key.toString().startsWith("_")) continue;
            it.remove();
        }
    }

    public void executeBM(String bm_name, CompositeMap context, CompositeMap parameterMap) throws Exception {
        SqlServiceContext sqlContext;
        CompositeMap localContext = context;
        if (localContext == null) {
            localContext = new CompositeMap();
        }
        if ((sqlContext = SqlServiceContext.createSqlServiceContext(localContext)) == null) {
            throw new RuntimeException("Can not create SqlServiceContext for context:" + localContext.toXML());
        }
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        sqlContext.setConnection(connection);
        try {
            BusinessModelService service = this.databaseServiceFactory.getModelService(bm_name, localContext);
            service.execute(parameterMap);
            connection.commit();
        }
        catch (Exception ex) {
            this.rollbackConnection(connection);
            throw new RuntimeException(ex);
        }
        finally {
            if (sqlContext != null) {
                sqlContext.freeConnection();
            }
        }
    }

    protected void executeProc(String procedure_name, int taskId, CompositeMap context) {
        this.logger.log(Level.CONFIG, "load procedure:{0}", new Object[]{procedure_name});
        Procedure proc = null;
        try {
            proc = this.procedureManager.loadProcedure(procedure_name);
        }
        catch (Exception ex) {
            throw BuiltinExceptionFactory.createResourceLoadException(this, procedure_name, ex);
        }
        this.executeProc(taskId, proc, context);
    }

    protected void executeProc(CompositeMap procedure_config, int taskId, CompositeMap context) {
        this.logger.log(Level.CONFIG, "load procedure:{0}", new Object[]{procedure_config});
        Procedure proc = null;
        try {
            proc = this.procedureManager.createProcedure(procedure_config);
        }
        catch (Exception ex) {
            throw BuiltinExceptionFactory.createResourceLoadException(this, String.valueOf(taskId), ex);
        }
        this.executeProc(taskId, proc, context);
    }

    protected void executeProc(int taskId, Procedure proc, CompositeMap context) {
        if (proc == null) {
            throw new IllegalArgumentException("Procedure can not be null!");
        }
        try {
            this.logger.log(Level.CONFIG, "load procedure:{0}", new Object[]{proc.getName()});
            String name = "task." + taskId;
            if (context != null) {
                context.putObject("/parameter/@task_id", (Object)taskId, true);
                ServiceInvoker.invokeProcedureWithTransaction(name, proc, this.serviceFactory, context);
            } else {
                ServiceInvoker.invokeProcedureWithTransaction(name, proc, this.serviceFactory);
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Error when invoking procedure " + proc.getName(), ex);
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String execDbFun(CompositeMap context, String function) throws Exception {
        SqlServiceContext sqlContext = SqlServiceContext.createSqlServiceContext(context);
        if (sqlContext == null) {
            throw new RuntimeException("Can not create SqlServiceContext for context:" + context.toXML());
        }
        Connection connection = this.getConnection();
        sqlContext.setConnection(connection);
        String errorMessage = null;
        CallableStatement proc = null;
        try {
            connection.setAutoCommit(false);
            proc = connection.prepareCall("{call ? := " + function + "}");
            proc.registerOutParameter(1, 12);
            proc.execute();
            errorMessage = proc.getString(1);
            if (errorMessage == null || "".equals(errorMessage)) {
                connection.commit();
            } else {
                connection.rollback();
            }
            proc.close();
            this.closeStatement(proc);
            if (sqlContext == null) return errorMessage;
        }
        catch (Exception e) {
            try {
                this.rollbackConnection(connection);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeStatement(proc);
                if (sqlContext == null) throw throwable;
                sqlContext.freeConnection();
                throw throwable;
            }
        }
        sqlContext.freeConnection();
        return errorMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void execDbProc(CompositeMap context, String executePkg) throws Exception {
        SqlServiceContext sqlContext = SqlServiceContext.createSqlServiceContext(context);
        if (sqlContext == null) {
            throw new RuntimeException("Can not create SqlServiceContext for context:" + context.toXML());
        }
        Connection connection = this.getConnection();
        sqlContext.setConnection(connection);
        CallableStatement proc = null;
        try {
            connection.setAutoCommit(false);
            proc = connection.prepareCall("{call " + executePkg + "}");
            proc.execute();
            connection.commit();
            proc.close();
            connection.setAutoCommit(true);
            this.closeStatement(proc);
            if (sqlContext == null) return;
        }
        catch (Exception e) {
            try {
                this.rollbackConnection(connection);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeStatement(proc);
                if (sqlContext == null) throw throwable;
                sqlContext.freeConnection();
                throw throwable;
            }
        }
        sqlContext.freeConnection();
        return;
    }

    private void rollbackConnection(Connection dbConn) {
        if (dbConn == null) {
            return;
        }
        try {
            dbConn.rollback();
        }
        catch (SQLException ex) {
            this.logger.log(Level.SEVERE, "", ex);
        }
    }

    private void closeStatement(Statement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            stmt.close();
        }
        catch (SQLException ex) {
            this.logger.log(Level.SEVERE, "", ex);
        }
    }

    public void onShutdown() throws Exception {
        if (this.taskThread != null && this.taskThread.isAlive()) {
            this.taskThread.interrupt();
        }
        this.taskThread = null;
    }

    public String getQueryTaskBM() {
        return this.queryTaskBM;
    }

    public void setQueryTaskBM(String queryTaskBM) {
        this.queryTaskBM = queryTaskBM;
    }

    public String getFinishTaskBM() {
        return this.finishTaskBM;
    }

    public void setFinishTaskBM(String finishTaskBM) {
        this.finishTaskBM = finishTaskBM;
    }

    public int getTryTime() {
        return this.tryTime;
    }

    public void setTryTime(int tryTime) {
        this.tryTime = tryTime;
    }

    private Connection getConnection() {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        if (connection == null) {
            throw new IllegalStateException("Can't get database connection from dataSource.");
        }
        return connection;
    }

    private String getFullStackTrace(Throwable exception) {
        String message = this.getExceptionStackTrace(exception);
        if (message.length() > 4000) {
            message = message.substring(0, 4000);
        }
        return message;
    }

    private String getExceptionStackTrace(Throwable exception) {
        if (exception == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream pw = new PrintStream(baos);
        exception.printStackTrace(pw);
        pw.close();
        return baos.toString();
    }
}

