/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.task.excel;

import aurora.application.action.DoDispatch;
import aurora.application.task.excel.IExcelTask;
import aurora.service.IService;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceFactory;
import aurora.service.http.HttpServiceInstance;
import aurora.service.http.WebContextInit;
import aurora.service.validation.ErrorMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.JSONAdaptor;
import uncertain.core.UncertainEngine;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;
import uncertain.util.LoggingUtil;

public class ExcelTaskServlet
extends HttpServlet {
    private static final long serialVersionUID = -8531728996484927927L;
    public static final String DEFAULT_JSON_CONTENT_TYPE = "application/json;charset=utf-8";
    public final String KEY_CHARSET = "GBK";
    private HttpServiceFactory mServiceFactory;
    private IObjectRegistry reg;
    private String excelDir;
    private IProcedureManager procedureManager;
    private Procedure pre_service_proc;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = config.getServletContext();
        UncertainEngine uncertainEngine = WebContextInit.getUncertainEngine(context);
        if (uncertainEngine == null) {
            throw new ServletException("Uncertain engine not initialized");
        }
        this.reg = uncertainEngine.getObjectRegistry();
        if (this.reg == null) {
            throw new ServletException("IObjectRegistry not initialized");
        }
        this.mServiceFactory = (HttpServiceFactory)this.reg.getInstanceOfType(HttpServiceFactory.class);
        if (this.mServiceFactory == null) {
            throw new ServletException("No ServiceFactory instance registered in UncertainEngine");
        }
        this.procedureManager = (IProcedureManager)this.reg.getInstanceOfType(IProcedureManager.class);
        if (this.procedureManager == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IProcedureManager.class, ((Object)((Object)this)).getClass().getName());
        }
        IExcelTask task = (IExcelTask)this.reg.getInstanceOfType(IExcelTask.class);
        if (task == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IExcelTask.class, ((Object)((Object)this)).getClass().getCanonicalName());
        }
        this.excelDir = task.getDir();
        CompositeMap proc_config = task.getProcedure();
        this.pre_service_proc = this.procedureManager.createProcedure(proc_config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String fileName = request.getParameter("file");
        if (fileName == null) {
            return;
        }
        HttpServiceInstance svc = this.mServiceFactory.createHttpService(fileName, request, response, this);
        try {
            boolean is_success = this.checkPreService(fileName, svc);
            if (is_success) {
                String operation = this.getOperation(request);
                File excelFile = new File(this.excelDir, fileName);
                if ("download".equals(operation)) {
                    this.downLoad(response, svc, excelFile);
                } else if ("delete".equals(operation)) {
                    this.delete(response, svc, excelFile);
                } else {
                    ErrorMessage message = new ErrorMessage(null, "This operation:" + operation + " is not support!", null);
                    svc.getServiceContext().setError(message.getObjectContext());
                    this.onCreateFailResponse(response, svc.getContextMap(), null);
                }
            } else {
                this.onCreateFailResponse(response, svc.getContextMap(), null);
            }
        }
        finally {
            svc.release();
            this.cleanUp(svc);
        }
    }

    protected boolean checkPreService(String fileName, HttpServiceInstance svc) {
        if (svc == null) {
            throw new IllegalArgumentException("HttpServiceInstance can not be null");
        }
        if (fileName == null || !fileName.endsWith(".xls") && !fileName.endsWith(".xlsx")) {
            ErrorMessage message = new ErrorMessage(null, "This file '" + fileName + "' is not an excel file!", null);
            svc.getServiceContext().setError(message.getObjectContext());
            return false;
        }
        boolean is_success = true;
        if (this.pre_service_proc != null) {
            try {
                is_success = svc.invoke(this.pre_service_proc);
            }
            catch (Exception e) {
                is_success = false;
            }
        }
        if (svc.getServiceContext().hasError()) {
            is_success = false;
        }
        return is_success;
    }

    protected String getOperation(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("HttpServletRequest can not be null");
        }
        String uri = request.getRequestURI();
        int begin = uri.lastIndexOf("/") + 1;
        String operation = uri.substring(begin);
        return operation;
    }

    protected void cleanUp(IService svc) {
        ((ServiceInstance)svc).clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downLoad(HttpServletResponse response, HttpServiceInstance svc, File file) throws IOException {
        if (svc == null) {
            throw new IllegalArgumentException("HttpServiceInstance can not be null");
        }
        if (!file.exists()) {
            ErrorMessage message = new ErrorMessage(null, "This file not exits or has been removed, please check it!", null);
            svc.getServiceContext().setError(message.getObjectContext());
            this.onCreateFailResponse(response, svc.getContextMap(), null);
            return;
        }
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("GBK");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
        ServletOutputStream os = response.getOutputStream();
        FileInputStream fis = null;
        try {
            int length;
            fis = new FileInputStream(file);
            byte[] bbuf = new byte[1024];
            while ((length = fis.read(bbuf)) != -1) {
                os.write(bbuf, 0, length);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    os.flush();
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void delete(HttpServletResponse response, HttpServiceInstance svc, File file) throws IOException {
        boolean is_success;
        if (svc == null) {
            throw new IllegalArgumentException("HttpServiceInstance can not be null");
        }
        ILogger logger = LoggingContext.getLogger(svc.getContextMap(), ((Object)((Object)this)).getClass().getCanonicalName());
        if (file.exists() && !(is_success = file.delete())) {
            ErrorMessage message = new ErrorMessage(null, "Can not delete this file!", null);
            svc.getServiceContext().setError(message.getObjectContext());
            this.onCreateFailResponse(response, svc.getContextMap(), null);
        }
        JSONObject json = new JSONObject();
        try {
            json.put("success", "true");
            PrintWriter out = svc.getResponse().getWriter();
            json.write(out);
        }
        catch (JSONException e) {
            LoggingUtil.logException(e, logger);
            ErrorMessage message = new ErrorMessage(null, e.getMessage(), null);
            svc.getServiceContext().setError(message.getObjectContext());
            this.onCreateFailResponse(response, svc.getContextMap(), e);
        }
    }

    public void onCreateFailResponse(HttpServletResponse response, CompositeMap context, Throwable thr) throws IOException {
        String url;
        this.prepareResponse(response);
        ServiceContext servieContext = ServiceContext.createServiceContext(context);
        ILogger logger = LoggingContext.getLogger(servieContext.getObjectContext(), ((Object)((Object)this)).getClass().getCanonicalName());
        if (thr != null) {
            LoggingUtil.logException(thr, logger);
        }
        if ((url = context.getString("dispatch_url")) != null) {
            DoDispatch dispath = new DoDispatch();
            try {
                dispath.onDoDispatch(servieContext);
            }
            catch (Exception e) {
                LoggingUtil.logException(e, logger);
            }
        } else {
            try {
                JSONObject json = new JSONObject();
                json.put("success", false);
                CompositeMap error_map = servieContext.getError();
                if (error_map != null) {
                    JSONObject err = JSONAdaptor.toJSONObject(error_map);
                    json.put("error", err);
                }
                PrintWriter out = response.getWriter();
                json.write(out);
            }
            catch (JSONException e) {
                LoggingUtil.logException(e, logger);
            }
        }
    }

    private void prepareResponse(HttpServletResponse response) {
        response.setContentType(DEFAULT_JSON_CONTENT_TYPE);
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
    }
}

