/*
 * Decompiled with CFR 0.152.
 */
package uncertain.cache;

import java.util.HashMap;
import java.util.Map;
import uncertain.cache.ICache;
import uncertain.cache.ICacheReader;
import uncertain.cache.ICacheWriter;
import uncertain.cache.INamedCacheFactory;
import uncertain.cache.MapBasedCache;
import uncertain.core.UncertainEngine;
import uncertain.mbean.MBeanRegister;

public class MapBasedCacheFactory
implements INamedCacheFactory {
    Map mNamedCacheMap = new HashMap(1000);
    MapBasedCache mDefaultCache = new MapBasedCache();
    boolean mRegisterMBean = true;
    UncertainEngine mEngine;
    String mName;
    int mInitialSize = 1000;
    float mLoadFactor = 0.75f;

    @Override
    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public MapBasedCacheFactory() {
        this("MapBasedCacheFactory");
    }

    public MapBasedCacheFactory(String name) {
        this.setName(name);
    }

    public MapBasedCacheFactory(UncertainEngine engine) {
        this.mEngine = engine;
    }

    @Override
    public ICacheReader getCacheReader() {
        return this.mDefaultCache;
    }

    @Override
    public ICacheWriter getCacheWriter() {
        return this.mDefaultCache;
    }

    @Override
    public ICache getCache() {
        return this.mDefaultCache;
    }

    @Override
    public ICache getNamedCache(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Cache name can't be null");
        }
        ICache cache = (ICache)this.mNamedCacheMap.get(name);
        if (cache == null) {
            cache = new MapBasedCache(this.mInitialSize, this.mLoadFactor);
            try {
                String mbean_name = this.mEngine == null ? "name=" + name : this.mEngine.getMBeanName("cache", "name=" + name);
                MBeanRegister.resiterMBean(mbean_name, cache);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.mNamedCacheMap.put(name, cache);
        }
        return cache;
    }

    @Override
    public void setNamedCache(String name, ICache cache) {
        this.mNamedCacheMap.put(name, cache);
    }

    @Override
    public boolean isCacheEnabled(String name) {
        return true;
    }

    public int getInitialSize() {
        return this.mInitialSize;
    }

    public void setInitialSize(int initialSize) {
        this.mInitialSize = initialSize;
    }

    public float getLoadFactor() {
        return this.mLoadFactor;
    }

    public void setLoadFactor(float loadFactor) {
        this.mLoadFactor = loadFactor;
    }
}

