/*
 * Decompiled with CFR 0.152.
 */
package uncertain.event;

import java.lang.reflect.Method;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.event.IEventHandle;
import uncertain.event.IRuntimeContext;
import uncertain.proc.ProcedureRunner;

public class ReflectionMethodHandle
implements IEventHandle {
    public static final int ARG_TYPE_NONE = 0;
    public static final int ARG_TYPE_SINGLE = 1;
    public static final int ARG_TYPE_MULTIPLE = 2;
    Method handle_method;
    Class[] param_types;
    Object handle_instance;
    int arg_type = 0;

    public ReflectionMethodHandle(Object instance, Method method, int arg_type) {
        this.handle_instance = instance;
        this.handle_method = method;
        this.arg_type = arg_type;
        if (arg_type == 2) {
            this.param_types = this.handle_method.getParameterTypes();
        }
    }

    @Override
    public int handleEvent(int sequence, CompositeMap context, Object[] parameters) throws Exception {
        return this.handleEvent(sequence, null, context, parameters);
    }

    @Override
    public int handleEvent(int sequence, ProcedureRunner runner, Object[] parameters) throws Exception {
        CompositeMap context = runner == null ? null : runner.getContext();
        return this.handleEvent(sequence, runner, context, parameters);
    }

    public int handleEvent(int sequence, ProcedureRunner runner, CompositeMap context, Object[] parameters) throws Exception {
        Object[] args = null;
        switch (this.arg_type) {
            case 1: {
                args = new Object[]{runner};
                break;
            }
            case 0: {
                args = null;
                break;
            }
            case 2: {
                args = new Object[this.param_types.length];
                if (this.param_types == null) break;
                int n = 0;
                for (int i = 0; i < this.param_types.length; ++i) {
                    args[i] = null;
                    if (i == 0 && ProcedureRunner.class.equals((Object)this.param_types[i])) {
                        args[0] = runner;
                    } else if (context != null && IRuntimeContext.class.isAssignableFrom(this.param_types[i])) {
                        args[i] = DynamicObject.cast(context, this.param_types[i]);
                    } else if (parameters != null) {
                        Object arg;
                        if (n < parameters.length && (arg = parameters[n]) != null && this.param_types[i].isAssignableFrom(arg.getClass())) {
                            args[i] = arg;
                        }
                        ++n;
                    }
                    if (args[i] != null || !this.param_types[i].isPrimitive()) continue;
                    throw new IllegalArgumentException("Target handle method " + this.handle_method.getDeclaringClass().getName() + "." + this.handle_method.getName() + ", parameter No." + (i + 1) + " is of primitive type " + this.param_types[i].getName() + ", but value got from context is null, this method can't be invoked");
                }
                break;
            }
        }
        Object value = this.handle_method.invoke(this.handle_instance, args);
        if (value != null) {
            return (Integer)value;
        }
        return 0;
    }

    public String toString() {
        return this.handle_instance.getClass().getName() + '.' + this.handle_method.getName();
    }
}

