/*
 * Decompiled with CFR 0.152.
 */
package uncertain.pkg;

import java.util.Iterator;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.exception.BuiltinExceptionFactory;

public class PackageConfig
extends DynamicObject {
    public static final String KEY_PATH = "path";
    public static final String KEY_SCHEMA_FILES = "schema-files";
    public static final String KEY_RESOURCE_FILES = "resource-files";

    private String[] getFiles(String array_name, String attrib_for_path) {
        CompositeMap schema_file_section = this.getObjectContext().getChild(array_name);
        if (schema_file_section == null) {
            return null;
        }
        Iterator it = schema_file_section.getChildIterator();
        if (it == null) {
            return null;
        }
        String[] paths = new String[schema_file_section.getChilds().size()];
        int i = 0;
        while (it.hasNext()) {
            CompositeMap item = (CompositeMap)it.next();
            String path = item.getString(attrib_for_path);
            if (path == null) {
                throw BuiltinExceptionFactory.createAttributeMissing(item.asLocatable(), attrib_for_path);
            }
            paths[i++] = path;
        }
        return paths;
    }

    public String[] getSchemaFiles() {
        return this.getFiles(KEY_SCHEMA_FILES, KEY_PATH);
    }

    public String[] getResourceFiles() {
        return this.getFiles(KEY_RESOURCE_FILES, KEY_PATH);
    }
}

