/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util.resource;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import uncertain.util.resource.ISourceFile;
import uncertain.util.resource.ISourceFileUpdateListener;

public class SourceFile
implements ISourceFile {
    long lastModified;
    String url;
    File sourceFile;
    List listenerList;

    public SourceFile(File file) {
        this.sourceFile = file;
        this.lastModified = file.lastModified();
        this.sourceFile = file;
        this.listenerList = new LinkedList();
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getVersion() {
        return Long.toString(this.lastModified);
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public File getFile() {
        return this.sourceFile;
    }

    @Override
    public void addUpdateListener(ISourceFileUpdateListener listener) {
        this.listenerList.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkModified() {
        long new_modified = this.sourceFile.lastModified();
        if (new_modified != this.lastModified) {
            this.lastModified = new_modified;
            if (this.listenerList.size() > 0) {
                List list = this.listenerList;
                synchronized (list) {
                    Object[] listeners = this.listenerList.toArray();
                    for (int i = 0; i < listeners.length; ++i) {
                        try {
                            ((ISourceFileUpdateListener)listeners[i]).onUpdate(this);
                            continue;
                        }
                        catch (Throwable thr) {
                            thr.printStackTrace();
                        }
                    }
                    this.listenerList.clear();
                }
            }
            return true;
        }
        return false;
    }
}

