/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.export;

import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import java.util.Iterator;
import java.util.logging.Level;
import javax.servlet.ServletException;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class ModelOutput {
    public static final String KEY_COLUMN_CONFIG = "_column_config_";
    public final String KEY_FILE_NAME = "_file_name_";
    public final String KEY_CHARSET = "GBK";
    public final String KEY_PROMPT = "prompt";
    public final String KEY_DATA_INDEX = "name";
    public static final String KEY_COLUMN = "column";
    public final String KEY_WIDTH = "width";
    public final String KEY_GENERATE_STATE = "_generate_state";
    public final String KEY_FORMAT = "_format";
    public final String KEY_EXCEL = "xls";
    IObjectRegistry mObjectRegistry;
    int modelQueryTagNum;

    public ModelOutput(IObjectRegistry registry) {
        this.mObjectRegistry = registry;
    }

    public int preInvokeService(ServiceContext context) throws Exception {
        CompositeMap parameters = context.getParameter();
        if (!parameters.getBoolean((Object)"_generate_state", false)) {
            return 0;
        }
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.export", (IObjectRegistry)this.mObjectRegistry);
        ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)context.getObjectContext());
        CompositeMap config = svc.getServiceConfigData().getChild("init-procedure");
        if (config == null) {
            mLogger.log(Level.SEVERE, "init-procedure tag must be defined");
            throw new ServletException("init-procedure tag must be defined");
        }
        String return_path = (String)svc.getServiceConfigData().getObject("service-output/@output");
        if (return_path == null) {
            mLogger.log(Level.SEVERE, "service-output tag must be defined");
            throw new ServletException("service-output tag must be defined");
        }
        if (!return_path.startsWith("/")) {
            return_path = "/" + return_path;
        }
        this.modelQueryTagNum = 0;
        this.createConsumerTag(config, return_path, parameters);
        if (this.modelQueryTagNum == 0) {
            mLogger.log(Level.SEVERE, "The path '" + return_path + "' can't find model-query tag");
            throw new ServletException("The path '" + return_path + "' can't find model-query tag");
        }
        return 0;
    }

    boolean createConsumerTag(CompositeMap actionConfig, String return_path, CompositeMap parameters) {
        if (this.modelQueryTagNum != 0) {
            return true;
        }
        Iterator iterator = actionConfig.getChildIterator();
        if (iterator != null) {
            while (iterator.hasNext() && !this.createConsumerTag((CompositeMap)iterator.next(), return_path, parameters)) {
            }
        } else {
            String rootpath = actionConfig.getString((Object)"rootpath");
            if (rootpath != null) {
                if (!rootpath.startsWith("/")) {
                    rootpath = "/model/" + rootpath;
                }
                if ("model-query".equals(actionConfig.getName()) && return_path.equalsIgnoreCase(rootpath)) {
                    actionConfig.putBoolean((Object)"fetchall", true);
                    if ("xls".equals(parameters.getString((Object)"_format"))) {
                        actionConfig.createChildByTag("consumer").createChildByTag("output-excel").setNameSpaceURI("http://www.aurora-framework.org/application");
                        ++this.modelQueryTagNum;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public int preCreateSuccessResponse(ServiceContext context) throws Exception {
        CompositeMap parameter = context.getParameter();
        if (!parameter.getBoolean((Object)"_generate_state", false)) {
            return 0;
        }
        return 2;
    }
}

