/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.poi;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import uncertain.composite.CompositeMap;

public class ExcelParse {
    public static CompositeMap parseFile(InputStream is, String suffix) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HSSFWorkbook wb = null;
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        CompositeMap excelData = new CompositeMap();
        if (!".xls".equalsIgnoreCase(suffix)) {
            throw new Exception("filetype is undefined");
        }
        wb = new HSSFWorkbook(is);
        int sheetLength = wb.getNumberOfSheets();
        for (int i = 0; i < sheetLength; ++i) {
            sheet = wb.getSheetAt(i);
            CompositeMap sheetData = new CompositeMap("sheet");
            sheetData.put((Object)"name", (Object)sheet.getSheetName());
            int lastRow = sheet.getLastRowNum();
            for (int firstRow = sheet.getFirstRowNum(); firstRow <= lastRow; ++firstRow) {
                row = sheet.getRow(firstRow);
                CompositeMap rowData = new CompositeMap("row");
                if (row != null) {
                    short lastCell = row.getLastCellNum();
                    for (int firstCell = row.getFirstCellNum(); firstCell < lastCell; ++firstCell) {
                        cell = row.getCell(firstCell);
                        if (cell == null) continue;
                        if (cell.getCellType() == 0) {
                            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                rowData.put((Object)("C" + firstCell), (Object)sdf.format(cell.getDateCellValue()));
                                continue;
                            }
                            rowData.put((Object)("C" + firstCell), (Object)cell.getNumericCellValue());
                            continue;
                        }
                        if (cell.getCellType() == 1) {
                            rowData.put((Object)("C" + firstCell), (Object)cell.toString());
                            continue;
                        }
                        if (cell.getCellType() == 3) continue;
                        rowData.put((Object)("C" + firstCell), (Object)"undefined");
                    }
                    rowData.putLong((Object)"maxCell", (long)row.getLastCellNum());
                }
                sheetData.addChild(rowData);
            }
            excelData.addChild(sheetData);
        }
        return excelData;
    }
}

