/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.cache;

import aurora.application.features.cache.CacheProvider;
import java.util.logging.Level;
import uncertain.cache.INamedCacheFactory;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.IObjectRegistry;

public class PeriodModeCacheProvider
extends CacheProvider {
    protected int refreshInterval = -1;
    private Thread periodThread;
    private boolean shutdown = false;

    public PeriodModeCacheProvider(IObjectRegistry registry, INamedCacheFactory cacheFactory) {
        super(registry, cacheFactory);
    }

    @Override
    public void initialize() {
        if (this.refreshInterval == -1) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "refreshInterval");
        }
        super.initialize();
        this.executePeriodMode();
    }

    private void executePeriodMode() {
        if (this.refreshInterval > 0) {
            this.periodThread = new Thread(){

                @Override
                public void run() {
                    while (!PeriodModeCacheProvider.this.shutdown) {
                        try {
                            Thread.sleep(PeriodModeCacheProvider.this.refreshInterval);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        try {
                            PeriodModeCacheProvider.this.reload();
                        }
                        catch (Exception e) {
                            PeriodModeCacheProvider.this.logger.log(Level.SEVERE, "", e);
                        }
                    }
                }
            };
            this.periodThread.start();
        }
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        if (this.periodThread != null && this.periodThread.isAlive()) {
            this.periodThread.interrupt();
        }
    }
}

